/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3CopyObjectOperation;
import com.amazonaws.services.s3control.model.S3Grant;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.services.s3control.model.transform.S3GrantStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3ObjectMetadataStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class S3CopyObjectOperationStaxUnmarshaller
implements Unmarshaller<S3CopyObjectOperation, StaxUnmarshallerContext> {
    private static S3CopyObjectOperationStaxUnmarshaller instance;

    public S3CopyObjectOperation unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3CopyObjectOperation s3CopyObjectOperation = new S3CopyObjectOperation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3CopyObjectOperation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TargetResource", targetDepth)) {
                    s3CopyObjectOperation.setTargetResource(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CannedAccessControlList", targetDepth)) {
                    s3CopyObjectOperation.setCannedAccessControlList(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccessControlGrants", targetDepth)) {
                    s3CopyObjectOperation.withAccessControlGrants(new ArrayList<S3Grant>());
                    continue;
                }
                if (context.testExpression("AccessControlGrants/member", targetDepth)) {
                    s3CopyObjectOperation.withAccessControlGrants(S3GrantStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetadataDirective", targetDepth)) {
                    s3CopyObjectOperation.setMetadataDirective(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ModifiedSinceConstraint", targetDepth)) {
                    s3CopyObjectOperation.setModifiedSinceConstraint(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("NewObjectMetadata", targetDepth)) {
                    s3CopyObjectOperation.setNewObjectMetadata(S3ObjectMetadataStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NewObjectTagging", targetDepth)) {
                    s3CopyObjectOperation.withNewObjectTagging(new ArrayList<S3Tag>());
                    continue;
                }
                if (context.testExpression("NewObjectTagging/member", targetDepth)) {
                    s3CopyObjectOperation.withNewObjectTagging(S3TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RedirectLocation", targetDepth)) {
                    s3CopyObjectOperation.setRedirectLocation(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequesterPays", targetDepth)) {
                    s3CopyObjectOperation.setRequesterPays(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageClass", targetDepth)) {
                    s3CopyObjectOperation.setStorageClass(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UnModifiedSinceConstraint", targetDepth)) {
                    s3CopyObjectOperation.setUnModifiedSinceConstraint(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("SSEAwsKmsKeyId", targetDepth)) {
                    s3CopyObjectOperation.setSSEAwsKmsKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetKeyPrefix", targetDepth)) {
                    s3CopyObjectOperation.setTargetKeyPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ObjectLockLegalHoldStatus", targetDepth)) {
                    s3CopyObjectOperation.setObjectLockLegalHoldStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ObjectLockMode", targetDepth)) {
                    s3CopyObjectOperation.setObjectLockMode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ObjectLockRetainUntilDate", targetDepth)) {
                    s3CopyObjectOperation.setObjectLockRetainUntilDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("BucketKeyEnabled", targetDepth)) {
                    s3CopyObjectOperation.setBucketKeyEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ChecksumAlgorithm", targetDepth)) continue;
                s3CopyObjectOperation.setChecksumAlgorithm(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3CopyObjectOperation;
    }

    public static S3CopyObjectOperationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3CopyObjectOperationStaxUnmarshaller();
        }
        return instance;
    }
}

