/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.PutBucketVersioningRequest;
import com.amazonaws.services.s3control.model.VersioningConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutBucketVersioningRequestMarshaller
implements Marshaller<Request<PutBucketVersioningRequest>, PutBucketVersioningRequest> {
    public Request<PutBucketVersioningRequest> marshall(PutBucketVersioningRequest putBucketVersioningRequest) {
        if (putBucketVersioningRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketVersioningRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketVersioningRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putBucketVersioningRequest.getAccountId()));
        }
        if (putBucketVersioningRequest.getMFA() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString((String)putBucketVersioningRequest.getMFA()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/versioning";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", putBucketVersioningRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            VersioningConfiguration versioningConfiguration = putBucketVersioningRequest.getVersioningConfiguration();
            if (versioningConfiguration != null) {
                xmlWriter.startElement("VersioningConfiguration");
                if (versioningConfiguration.getMFADelete() != null) {
                    xmlWriter.startElement("MfaDelete").value(versioningConfiguration.getMFADelete()).endElement();
                }
                if (versioningConfiguration.getStatus() != null) {
                    xmlWriter.startElement("Status").value(versioningConfiguration.getStatus()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

