/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.MatchObjectSize;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MatchObjectSizeStaxUnmarshaller
implements Unmarshaller<MatchObjectSize, StaxUnmarshallerContext> {
    private static MatchObjectSizeStaxUnmarshaller instance;

    public MatchObjectSize unmarshall(StaxUnmarshallerContext context) throws Exception {
        MatchObjectSize matchObjectSize = new MatchObjectSize();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return matchObjectSize;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("BytesGreaterThan", targetDepth)) {
                    matchObjectSize.setBytesGreaterThan(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("BytesLessThan", targetDepth)) continue;
                matchObjectSize.setBytesLessThan(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return matchObjectSize;
    }

    public static MatchObjectSizeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MatchObjectSizeStaxUnmarshaller();
        }
        return instance;
    }
}

