/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.KeyNameConstraint;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class KeyNameConstraintStaxUnmarshaller
implements Unmarshaller<KeyNameConstraint, StaxUnmarshallerContext> {
    private static KeyNameConstraintStaxUnmarshaller instance;

    public KeyNameConstraint unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyNameConstraint keyNameConstraint = new KeyNameConstraint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyNameConstraint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MatchAnyPrefix", targetDepth)) {
                    keyNameConstraint.withMatchAnyPrefix(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("MatchAnyPrefix/member", targetDepth)) {
                    keyNameConstraint.withMatchAnyPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MatchAnySuffix", targetDepth)) {
                    keyNameConstraint.withMatchAnySuffix(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("MatchAnySuffix/member", targetDepth)) {
                    keyNameConstraint.withMatchAnySuffix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MatchAnySubstring", targetDepth)) {
                    keyNameConstraint.withMatchAnySubstring(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("MatchAnySubstring/member", targetDepth)) continue;
                keyNameConstraint.withMatchAnySubstring(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyNameConstraint;
    }

    public static KeyNameConstraintStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyNameConstraintStaxUnmarshaller();
        }
        return instance;
    }
}

