/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.S3Grant;
import com.amazonaws.services.s3control.model.S3ObjectOwner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3AccessControlList
implements Serializable,
Cloneable {
    private S3ObjectOwner owner;
    private List<S3Grant> grants;

    public void setOwner(S3ObjectOwner owner) {
        this.owner = owner;
    }

    public S3ObjectOwner getOwner() {
        return this.owner;
    }

    public S3AccessControlList withOwner(S3ObjectOwner owner) {
        this.setOwner(owner);
        return this;
    }

    public List<S3Grant> getGrants() {
        return this.grants;
    }

    public void setGrants(Collection<S3Grant> grants) {
        if (grants == null) {
            this.grants = null;
            return;
        }
        this.grants = new ArrayList<S3Grant>(grants);
    }

    public S3AccessControlList withGrants(S3Grant ... grants) {
        if (this.grants == null) {
            this.setGrants(new ArrayList<S3Grant>(grants.length));
        }
        for (S3Grant ele : grants) {
            this.grants.add(ele);
        }
        return this;
    }

    public S3AccessControlList withGrants(Collection<S3Grant> grants) {
        this.setGrants(grants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getGrants() != null) {
            sb.append("Grants: ").append(this.getGrants());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessControlList)) {
            return false;
        }
        S3AccessControlList other = (S3AccessControlList)obj;
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getGrants() == null ^ this.getGrants() == null) {
            return false;
        }
        return other.getGrants() == null || other.getGrants().equals(this.getGrants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getGrants() == null ? 0 : this.getGrants().hashCode());
        return hashCode;
    }

    public S3AccessControlList clone() {
        try {
            return (S3AccessControlList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

