/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.MultiRegionAccessPointStatus;
import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3control.model.RegionReport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MultiRegionAccessPointReport
implements Serializable,
Cloneable {
    private String name;
    private String alias;
    private Date createdAt;
    private PublicAccessBlockConfiguration publicAccessBlock;
    private String status;
    private List<RegionReport> regions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MultiRegionAccessPointReport withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public MultiRegionAccessPointReport withAlias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public MultiRegionAccessPointReport withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setPublicAccessBlock(PublicAccessBlockConfiguration publicAccessBlock) {
        this.publicAccessBlock = publicAccessBlock;
    }

    public PublicAccessBlockConfiguration getPublicAccessBlock() {
        return this.publicAccessBlock;
    }

    public MultiRegionAccessPointReport withPublicAccessBlock(PublicAccessBlockConfiguration publicAccessBlock) {
        this.setPublicAccessBlock(publicAccessBlock);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public MultiRegionAccessPointReport withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public MultiRegionAccessPointReport withStatus(MultiRegionAccessPointStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<RegionReport> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<RegionReport> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<RegionReport>(regions);
    }

    public MultiRegionAccessPointReport withRegions(RegionReport ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<RegionReport>(regions.length));
        }
        for (RegionReport ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public MultiRegionAccessPointReport withRegions(Collection<RegionReport> regions) {
        this.setRegions(regions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAlias() != null) {
            sb.append("Alias: ").append(this.getAlias()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getPublicAccessBlock() != null) {
            sb.append("PublicAccessBlock: ").append(this.getPublicAccessBlock()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionAccessPointReport)) {
            return false;
        }
        MultiRegionAccessPointReport other = (MultiRegionAccessPointReport)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getPublicAccessBlock() == null ^ this.getPublicAccessBlock() == null) {
            return false;
        }
        if (other.getPublicAccessBlock() != null && !other.getPublicAccessBlock().equals(this.getPublicAccessBlock())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        return other.getRegions() == null || other.getRegions().equals(this.getRegions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getPublicAccessBlock() == null ? 0 : this.getPublicAccessBlock().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        return hashCode;
    }

    public MultiRegionAccessPointReport clone() {
        try {
            return (MultiRegionAccessPointReport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

