/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53recoveryreadiness.model.Message;
import com.amazonaws.services.route53recoveryreadiness.model.Readiness;
import com.amazonaws.services.route53recoveryreadiness.model.transform.RuleResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RuleResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Date lastCheckedTimestamp;
    private List<Message> messages;
    private String readiness;
    private String ruleId;

    public void setLastCheckedTimestamp(Date lastCheckedTimestamp) {
        this.lastCheckedTimestamp = lastCheckedTimestamp;
    }

    public Date getLastCheckedTimestamp() {
        return this.lastCheckedTimestamp;
    }

    public RuleResult withLastCheckedTimestamp(Date lastCheckedTimestamp) {
        this.setLastCheckedTimestamp(lastCheckedTimestamp);
        return this;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public RuleResult withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public RuleResult withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public void setReadiness(String readiness) {
        this.readiness = readiness;
    }

    public String getReadiness() {
        return this.readiness;
    }

    public RuleResult withReadiness(String readiness) {
        this.setReadiness(readiness);
        return this;
    }

    public RuleResult withReadiness(Readiness readiness) {
        this.readiness = readiness.toString();
        return this;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public RuleResult withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLastCheckedTimestamp() != null) {
            sb.append("LastCheckedTimestamp: ").append(this.getLastCheckedTimestamp()).append(",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getReadiness() != null) {
            sb.append("Readiness: ").append(this.getReadiness()).append(",");
        }
        if (this.getRuleId() != null) {
            sb.append("RuleId: ").append(this.getRuleId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleResult)) {
            return false;
        }
        RuleResult other = (RuleResult)obj;
        if (other.getLastCheckedTimestamp() == null ^ this.getLastCheckedTimestamp() == null) {
            return false;
        }
        if (other.getLastCheckedTimestamp() != null && !other.getLastCheckedTimestamp().equals(this.getLastCheckedTimestamp())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getReadiness() == null ^ this.getReadiness() == null) {
            return false;
        }
        if (other.getReadiness() != null && !other.getReadiness().equals(this.getReadiness())) {
            return false;
        }
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        return other.getRuleId() == null || other.getRuleId().equals(this.getRuleId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLastCheckedTimestamp() == null ? 0 : this.getLastCheckedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getReadiness() == null ? 0 : this.getReadiness().hashCode());
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        return hashCode;
    }

    public RuleResult clone() {
        try {
            return (RuleResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

