/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resourceexplorer2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about an additional property that describes a resource, that you can optionally include in the view. This
 * lets you view that property in search results, and filter your search results based on the value of the property.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/IncludedProperty"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IncludedProperty implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the property that is included in this view.
     * </p>
     * <p>
     * You can specify the following property names for this field:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Tags</code>
     * </p>
     * </li>
     * </ul>
     */
    private String name;

    /**
     * <p>
     * The name of the property that is included in this view.
     * </p>
     * <p>
     * You can specify the following property names for this field:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Tags</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param name
     *        The name of the property that is included in this view.</p>
     *        <p>
     *        You can specify the following property names for this field:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Tags</code>
     *        </p>
     *        </li>
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the property that is included in this view.
     * </p>
     * <p>
     * You can specify the following property names for this field:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Tags</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the property that is included in this view.</p>
     *         <p>
     *         You can specify the following property names for this field:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Tags</code>
     *         </p>
     *         </li>
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the property that is included in this view.
     * </p>
     * <p>
     * You can specify the following property names for this field:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Tags</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param name
     *        The name of the property that is included in this view.</p>
     *        <p>
     *        You can specify the following property names for this field:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Tags</code>
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IncludedProperty withName(String name) {
        setName(name);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IncludedProperty == false)
            return false;
        IncludedProperty other = (IncludedProperty) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        return hashCode;
    }

    @Override
    public IncludedProperty clone() {
        try {
            return (IncludedProperty) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.resourceexplorer2.model.transform.IncludedPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
