/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.CostFrequency;
import com.amazonaws.services.resiliencehub.model.transform.CostMarshaller;
import java.io.Serializable;

public class Cost
implements Serializable,
Cloneable,
StructuredPojo {
    private Double amount;
    private String currency;
    private String frequency;

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Double getAmount() {
        return this.amount;
    }

    public Cost withAmount(Double amount) {
        this.setAmount(amount);
        return this;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Cost withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public Cost withFrequency(String frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public Cost withFrequency(CostFrequency frequency) {
        this.frequency = frequency.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmount() != null) {
            sb.append("Amount: ").append(this.getAmount()).append(",");
        }
        if (this.getCurrency() != null) {
            sb.append("Currency: ").append(this.getCurrency()).append(",");
        }
        if (this.getFrequency() != null) {
            sb.append("Frequency: ").append(this.getFrequency());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cost)) {
            return false;
        }
        Cost other = (Cost)obj;
        if (other.getAmount() == null ^ this.getAmount() == null) {
            return false;
        }
        if (other.getAmount() != null && !other.getAmount().equals(this.getAmount())) {
            return false;
        }
        if (other.getCurrency() == null ^ this.getCurrency() == null) {
            return false;
        }
        if (other.getCurrency() != null && !other.getCurrency().equals(this.getCurrency())) {
            return false;
        }
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        return other.getFrequency() == null || other.getFrequency().equals(this.getFrequency());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmount() == null ? 0 : this.getAmount().hashCode());
        hashCode = 31 * hashCode + (this.getCurrency() == null ? 0 : this.getCurrency().hashCode());
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        return hashCode;
    }

    public Cost clone() {
        try {
            return (Cost)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

