/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.ValidationData;
import java.util.List;

@SdkInternalApi
public class ValidationDataMarshaller {
    private static final MarshallingInfo<List> ASSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Assets").build();
    private static final ValidationDataMarshaller instance = new ValidationDataMarshaller();

    public static ValidationDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ValidationData validationData, ProtocolMarshaller protocolMarshaller) {
        if (validationData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(validationData.getAssets(), ASSETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

