/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.DatasetStats;

@SdkInternalApi
public class DatasetStatsMarshaller {
    private static final MarshallingInfo<Integer> LABELEDENTRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabeledEntries").build();
    private static final MarshallingInfo<Integer> TOTALENTRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalEntries").build();
    private static final MarshallingInfo<Integer> TOTALLABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalLabels").build();
    private static final MarshallingInfo<Integer> ERRORENTRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorEntries").build();
    private static final DatasetStatsMarshaller instance = new DatasetStatsMarshaller();

    public static DatasetStatsMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatasetStats datasetStats, ProtocolMarshaller protocolMarshaller) {
        if (datasetStats == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datasetStats.getLabeledEntries(), LABELEDENTRIES_BINDING);
            protocolMarshaller.marshall((Object)datasetStats.getTotalEntries(), TOTALENTRIES_BINDING);
            protocolMarshaller.marshall((Object)datasetStats.getTotalLabels(), TOTALLABELS_BINDING);
            protocolMarshaller.marshall((Object)datasetStats.getErrorEntries(), ERRORENTRIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

