/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.Celebrity;
import java.util.List;

@SdkInternalApi
public class CelebrityMarshaller {
    private static final MarshallingInfo<List> URLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Urls").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").build();
    private static final MarshallingInfo<Float> MATCHCONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchConfidence").build();
    private static final MarshallingInfo<StructuredPojo> KNOWNGENDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KnownGender").build();
    private static final CelebrityMarshaller instance = new CelebrityMarshaller();

    public static CelebrityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Celebrity celebrity, ProtocolMarshaller protocolMarshaller) {
        if (celebrity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(celebrity.getUrls(), URLS_BINDING);
            protocolMarshaller.marshall((Object)celebrity.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)celebrity.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)celebrity.getFace(), FACE_BINDING);
            protocolMarshaller.marshall((Object)celebrity.getMatchConfidence(), MATCHCONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)celebrity.getKnownGender(), KNOWNGENDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

