/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.BoundingBox;
import com.amazonaws.services.rekognition.model.DominantColor;
import com.amazonaws.services.rekognition.model.transform.InstanceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Instance
implements Serializable,
Cloneable,
StructuredPojo {
    private BoundingBox boundingBox;
    private Float confidence;
    private List<DominantColor> dominantColors;

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Instance withBoundingBox(BoundingBox boundingBox) {
        this.setBoundingBox(boundingBox);
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public Instance withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public List<DominantColor> getDominantColors() {
        return this.dominantColors;
    }

    public void setDominantColors(Collection<DominantColor> dominantColors) {
        if (dominantColors == null) {
            this.dominantColors = null;
            return;
        }
        this.dominantColors = new ArrayList<DominantColor>(dominantColors);
    }

    public Instance withDominantColors(DominantColor ... dominantColors) {
        if (this.dominantColors == null) {
            this.setDominantColors(new ArrayList<DominantColor>(dominantColors.length));
        }
        for (DominantColor ele : dominantColors) {
            this.dominantColors.add(ele);
        }
        return this;
    }

    public Instance withDominantColors(Collection<DominantColor> dominantColors) {
        this.setDominantColors(dominantColors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBoundingBox() != null) {
            sb.append("BoundingBox: ").append(this.getBoundingBox()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getDominantColors() != null) {
            sb.append("DominantColors: ").append(this.getDominantColors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.getBoundingBox() == null ^ this.getBoundingBox() == null) {
            return false;
        }
        if (other.getBoundingBox() != null && !other.getBoundingBox().equals(this.getBoundingBox())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getDominantColors() == null ^ this.getDominantColors() == null) {
            return false;
        }
        return other.getDominantColors() == null || other.getDominantColors().equals(this.getDominantColors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBoundingBox() == null ? 0 : this.getBoundingBox().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getDominantColors() == null ? 0 : this.getDominantColors().hashCode());
        return hashCode;
    }

    public Instance clone() {
        try {
            return (Instance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

