/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.GlobalCluster;
import com.amazonaws.services.rds.model.GlobalClusterMember;
import com.amazonaws.services.rds.model.transform.FailoverStateStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.GlobalClusterMemberStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class GlobalClusterStaxUnmarshaller
implements Unmarshaller<GlobalCluster, StaxUnmarshallerContext> {
    private static GlobalClusterStaxUnmarshaller instance;

    public GlobalCluster unmarshall(StaxUnmarshallerContext context) throws Exception {
        GlobalCluster globalCluster = new GlobalCluster();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return globalCluster;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("GlobalClusterIdentifier", targetDepth)) {
                    globalCluster.setGlobalClusterIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("GlobalClusterResourceId", targetDepth)) {
                    globalCluster.setGlobalClusterResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("GlobalClusterArn", targetDepth)) {
                    globalCluster.setGlobalClusterArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    globalCluster.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    globalCluster.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    globalCluster.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineLifecycleSupport", targetDepth)) {
                    globalCluster.setEngineLifecycleSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    globalCluster.setDatabaseName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageEncrypted", targetDepth)) {
                    globalCluster.setStorageEncrypted(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeletionProtection", targetDepth)) {
                    globalCluster.setDeletionProtection(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("GlobalClusterMembers", targetDepth)) {
                    globalCluster.withGlobalClusterMembers(new ArrayList<GlobalClusterMember>());
                    continue;
                }
                if (context.testExpression("GlobalClusterMembers/GlobalClusterMember", targetDepth)) {
                    globalCluster.withGlobalClusterMembers(GlobalClusterMemberStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("FailoverState", targetDepth)) continue;
                globalCluster.setFailoverState(FailoverStateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return globalCluster;
    }

    public static GlobalClusterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalClusterStaxUnmarshaller();
        }
        return instance;
    }
}

