/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ServiceType;
import com.amazonaws.services.quicksight.model.transform.AuthorizedTargetsByServiceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthorizedTargetsByService
implements Serializable,
Cloneable,
StructuredPojo {
    private String service;
    private List<String> authorizedTargets;

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public AuthorizedTargetsByService withService(String service) {
        this.setService(service);
        return this;
    }

    public AuthorizedTargetsByService withService(ServiceType service) {
        this.service = service.toString();
        return this;
    }

    public List<String> getAuthorizedTargets() {
        return this.authorizedTargets;
    }

    public void setAuthorizedTargets(Collection<String> authorizedTargets) {
        if (authorizedTargets == null) {
            this.authorizedTargets = null;
            return;
        }
        this.authorizedTargets = new ArrayList<String>(authorizedTargets);
    }

    public AuthorizedTargetsByService withAuthorizedTargets(String ... authorizedTargets) {
        if (this.authorizedTargets == null) {
            this.setAuthorizedTargets(new ArrayList<String>(authorizedTargets.length));
        }
        for (String ele : authorizedTargets) {
            this.authorizedTargets.add(ele);
        }
        return this;
    }

    public AuthorizedTargetsByService withAuthorizedTargets(Collection<String> authorizedTargets) {
        this.setAuthorizedTargets(authorizedTargets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService()).append(",");
        }
        if (this.getAuthorizedTargets() != null) {
            sb.append("AuthorizedTargets: ").append(this.getAuthorizedTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTargetsByService)) {
            return false;
        }
        AuthorizedTargetsByService other = (AuthorizedTargetsByService)obj;
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        if (other.getService() != null && !other.getService().equals(this.getService())) {
            return false;
        }
        if (other.getAuthorizedTargets() == null ^ this.getAuthorizedTargets() == null) {
            return false;
        }
        return other.getAuthorizedTargets() == null || other.getAuthorizedTargets().equals(this.getAuthorizedTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizedTargets() == null ? 0 : this.getAuthorizedTargets().hashCode());
        return hashCode;
    }

    public AuthorizedTargetsByService clone() {
        try {
            return (AuthorizedTargetsByService)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthorizedTargetsByServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

