/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.SemanticType;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class SemanticTypeMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").build();
    private static final MarshallingInfo<String> SUBTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubTypeName").build();
    private static final MarshallingInfo<Map> TYPEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeParameters").build();
    private static final MarshallingInfo<String> TRUTHYCELLVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TruthyCellValue").build();
    private static final MarshallingInfo<List> TRUTHYCELLVALUESYNONYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TruthyCellValueSynonyms").build();
    private static final MarshallingInfo<String> FALSEYCELLVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FalseyCellValue").build();
    private static final MarshallingInfo<List> FALSEYCELLVALUESYNONYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FalseyCellValueSynonyms").build();
    private static final SemanticTypeMarshaller instance = new SemanticTypeMarshaller();

    public static SemanticTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(SemanticType semanticType, ProtocolMarshaller protocolMarshaller) {
        if (semanticType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)semanticType.getTypeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)semanticType.getSubTypeName(), SUBTYPENAME_BINDING);
            protocolMarshaller.marshall(semanticType.getTypeParameters(), TYPEPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)semanticType.getTruthyCellValue(), TRUTHYCELLVALUE_BINDING);
            protocolMarshaller.marshall(semanticType.getTruthyCellValueSynonyms(), TRUTHYCELLVALUESYNONYMS_BINDING);
            protocolMarshaller.marshall((Object)semanticType.getFalseyCellValue(), FALSEYCELLVALUE_BINDING);
            protocolMarshaller.marshall(semanticType.getFalseyCellValueSynonyms(), FALSEYCELLVALUESYNONYMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

