/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.SemanticTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemanticType
implements Serializable,
Cloneable,
StructuredPojo {
    private String typeName;
    private String subTypeName;
    private Map<String, String> typeParameters;
    private String truthyCellValue;
    private List<String> truthyCellValueSynonyms;
    private String falseyCellValue;
    private List<String> falseyCellValueSynonyms;

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public SemanticType withTypeName(String typeName) {
        this.setTypeName(typeName);
        return this;
    }

    public void setSubTypeName(String subTypeName) {
        this.subTypeName = subTypeName;
    }

    public String getSubTypeName() {
        return this.subTypeName;
    }

    public SemanticType withSubTypeName(String subTypeName) {
        this.setSubTypeName(subTypeName);
        return this;
    }

    public Map<String, String> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(Map<String, String> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public SemanticType withTypeParameters(Map<String, String> typeParameters) {
        this.setTypeParameters(typeParameters);
        return this;
    }

    public SemanticType addTypeParametersEntry(String key, String value) {
        if (null == this.typeParameters) {
            this.typeParameters = new HashMap<String, String>();
        }
        if (this.typeParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.typeParameters.put(key, value);
        return this;
    }

    public SemanticType clearTypeParametersEntries() {
        this.typeParameters = null;
        return this;
    }

    public void setTruthyCellValue(String truthyCellValue) {
        this.truthyCellValue = truthyCellValue;
    }

    public String getTruthyCellValue() {
        return this.truthyCellValue;
    }

    public SemanticType withTruthyCellValue(String truthyCellValue) {
        this.setTruthyCellValue(truthyCellValue);
        return this;
    }

    public List<String> getTruthyCellValueSynonyms() {
        return this.truthyCellValueSynonyms;
    }

    public void setTruthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms) {
        if (truthyCellValueSynonyms == null) {
            this.truthyCellValueSynonyms = null;
            return;
        }
        this.truthyCellValueSynonyms = new ArrayList<String>(truthyCellValueSynonyms);
    }

    public SemanticType withTruthyCellValueSynonyms(String ... truthyCellValueSynonyms) {
        if (this.truthyCellValueSynonyms == null) {
            this.setTruthyCellValueSynonyms(new ArrayList<String>(truthyCellValueSynonyms.length));
        }
        for (String ele : truthyCellValueSynonyms) {
            this.truthyCellValueSynonyms.add(ele);
        }
        return this;
    }

    public SemanticType withTruthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms) {
        this.setTruthyCellValueSynonyms(truthyCellValueSynonyms);
        return this;
    }

    public void setFalseyCellValue(String falseyCellValue) {
        this.falseyCellValue = falseyCellValue;
    }

    public String getFalseyCellValue() {
        return this.falseyCellValue;
    }

    public SemanticType withFalseyCellValue(String falseyCellValue) {
        this.setFalseyCellValue(falseyCellValue);
        return this;
    }

    public List<String> getFalseyCellValueSynonyms() {
        return this.falseyCellValueSynonyms;
    }

    public void setFalseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms) {
        if (falseyCellValueSynonyms == null) {
            this.falseyCellValueSynonyms = null;
            return;
        }
        this.falseyCellValueSynonyms = new ArrayList<String>(falseyCellValueSynonyms);
    }

    public SemanticType withFalseyCellValueSynonyms(String ... falseyCellValueSynonyms) {
        if (this.falseyCellValueSynonyms == null) {
            this.setFalseyCellValueSynonyms(new ArrayList<String>(falseyCellValueSynonyms.length));
        }
        for (String ele : falseyCellValueSynonyms) {
            this.falseyCellValueSynonyms.add(ele);
        }
        return this;
    }

    public SemanticType withFalseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms) {
        this.setFalseyCellValueSynonyms(falseyCellValueSynonyms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypeName() != null) {
            sb.append("TypeName: ").append(this.getTypeName()).append(",");
        }
        if (this.getSubTypeName() != null) {
            sb.append("SubTypeName: ").append(this.getSubTypeName()).append(",");
        }
        if (this.getTypeParameters() != null) {
            sb.append("TypeParameters: ").append(this.getTypeParameters()).append(",");
        }
        if (this.getTruthyCellValue() != null) {
            sb.append("TruthyCellValue: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTruthyCellValueSynonyms() != null) {
            sb.append("TruthyCellValueSynonyms: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFalseyCellValue() != null) {
            sb.append("FalseyCellValue: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFalseyCellValueSynonyms() != null) {
            sb.append("FalseyCellValueSynonyms: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticType)) {
            return false;
        }
        SemanticType other = (SemanticType)obj;
        if (other.getTypeName() == null ^ this.getTypeName() == null) {
            return false;
        }
        if (other.getTypeName() != null && !other.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        if (other.getSubTypeName() == null ^ this.getSubTypeName() == null) {
            return false;
        }
        if (other.getSubTypeName() != null && !other.getSubTypeName().equals(this.getSubTypeName())) {
            return false;
        }
        if (other.getTypeParameters() == null ^ this.getTypeParameters() == null) {
            return false;
        }
        if (other.getTypeParameters() != null && !other.getTypeParameters().equals(this.getTypeParameters())) {
            return false;
        }
        if (other.getTruthyCellValue() == null ^ this.getTruthyCellValue() == null) {
            return false;
        }
        if (other.getTruthyCellValue() != null && !other.getTruthyCellValue().equals(this.getTruthyCellValue())) {
            return false;
        }
        if (other.getTruthyCellValueSynonyms() == null ^ this.getTruthyCellValueSynonyms() == null) {
            return false;
        }
        if (other.getTruthyCellValueSynonyms() != null && !other.getTruthyCellValueSynonyms().equals(this.getTruthyCellValueSynonyms())) {
            return false;
        }
        if (other.getFalseyCellValue() == null ^ this.getFalseyCellValue() == null) {
            return false;
        }
        if (other.getFalseyCellValue() != null && !other.getFalseyCellValue().equals(this.getFalseyCellValue())) {
            return false;
        }
        if (other.getFalseyCellValueSynonyms() == null ^ this.getFalseyCellValueSynonyms() == null) {
            return false;
        }
        return other.getFalseyCellValueSynonyms() == null || other.getFalseyCellValueSynonyms().equals(this.getFalseyCellValueSynonyms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTypeName() == null ? 0 : this.getTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getSubTypeName() == null ? 0 : this.getSubTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getTypeParameters() == null ? 0 : this.getTypeParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTruthyCellValue() == null ? 0 : this.getTruthyCellValue().hashCode());
        hashCode = 31 * hashCode + (this.getTruthyCellValueSynonyms() == null ? 0 : this.getTruthyCellValueSynonyms().hashCode());
        hashCode = 31 * hashCode + (this.getFalseyCellValue() == null ? 0 : this.getFalseyCellValue().hashCode());
        hashCode = 31 * hashCode + (this.getFalseyCellValueSynonyms() == null ? 0 : this.getFalseyCellValueSynonyms().hashCode());
        return hashCode;
    }

    public SemanticType clone() {
        try {
            return (SemanticType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SemanticTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

