/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.S3Source;
import java.util.List;

@SdkInternalApi
public class S3SourceMarshaller {
    private static final MarshallingInfo<String> DATASOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceArn").build();
    private static final MarshallingInfo<StructuredPojo> UPLOADSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UploadSettings").build();
    private static final MarshallingInfo<List> INPUTCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputColumns").build();
    private static final S3SourceMarshaller instance = new S3SourceMarshaller();

    public static S3SourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Source s3Source, ProtocolMarshaller protocolMarshaller) {
        if (s3Source == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Source.getDataSourceArn(), DATASOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)s3Source.getUploadSettings(), UPLOADSETTINGS_BINDING);
            protocolMarshaller.marshall(s3Source.getInputColumns(), INPUTCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

