/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.InsightVisual;
import java.util.List;

@SdkInternalApi
public class InsightVisualMarshaller {
    private static final MarshallingInfo<String> VISUALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisualId").build();
    private static final MarshallingInfo<StructuredPojo> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<StructuredPojo> SUBTITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subtitle").build();
    private static final MarshallingInfo<StructuredPojo> INSIGHTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InsightConfiguration").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Actions").build();
    private static final MarshallingInfo<String> DATASETIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetIdentifier").build();
    private static final InsightVisualMarshaller instance = new InsightVisualMarshaller();

    public static InsightVisualMarshaller getInstance() {
        return instance;
    }

    public void marshall(InsightVisual insightVisual, ProtocolMarshaller protocolMarshaller) {
        if (insightVisual == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)insightVisual.getVisualId(), VISUALID_BINDING);
            protocolMarshaller.marshall((Object)insightVisual.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)insightVisual.getSubtitle(), SUBTITLE_BINDING);
            protocolMarshaller.marshall((Object)insightVisual.getInsightConfiguration(), INSIGHTCONFIGURATION_BINDING);
            protocolMarshaller.marshall(insightVisual.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)insightVisual.getDataSetIdentifier(), DATASETIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

