/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.InsightConfiguration;
import com.amazonaws.services.quicksight.model.VisualCustomAction;
import com.amazonaws.services.quicksight.model.VisualSubtitleLabelOptions;
import com.amazonaws.services.quicksight.model.VisualTitleLabelOptions;
import com.amazonaws.services.quicksight.model.transform.InsightVisualMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InsightVisual
implements Serializable,
Cloneable,
StructuredPojo {
    private String visualId;
    private VisualTitleLabelOptions title;
    private VisualSubtitleLabelOptions subtitle;
    private InsightConfiguration insightConfiguration;
    private List<VisualCustomAction> actions;
    private String dataSetIdentifier;

    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }

    public String getVisualId() {
        return this.visualId;
    }

    public InsightVisual withVisualId(String visualId) {
        this.setVisualId(visualId);
        return this;
    }

    public void setTitle(VisualTitleLabelOptions title) {
        this.title = title;
    }

    public VisualTitleLabelOptions getTitle() {
        return this.title;
    }

    public InsightVisual withTitle(VisualTitleLabelOptions title) {
        this.setTitle(title);
        return this;
    }

    public void setSubtitle(VisualSubtitleLabelOptions subtitle) {
        this.subtitle = subtitle;
    }

    public VisualSubtitleLabelOptions getSubtitle() {
        return this.subtitle;
    }

    public InsightVisual withSubtitle(VisualSubtitleLabelOptions subtitle) {
        this.setSubtitle(subtitle);
        return this;
    }

    public void setInsightConfiguration(InsightConfiguration insightConfiguration) {
        this.insightConfiguration = insightConfiguration;
    }

    public InsightConfiguration getInsightConfiguration() {
        return this.insightConfiguration;
    }

    public InsightVisual withInsightConfiguration(InsightConfiguration insightConfiguration) {
        this.setInsightConfiguration(insightConfiguration);
        return this;
    }

    public List<VisualCustomAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<VisualCustomAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<VisualCustomAction>(actions);
    }

    public InsightVisual withActions(VisualCustomAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<VisualCustomAction>(actions.length));
        }
        for (VisualCustomAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public InsightVisual withActions(Collection<VisualCustomAction> actions) {
        this.setActions(actions);
        return this;
    }

    public void setDataSetIdentifier(String dataSetIdentifier) {
        this.dataSetIdentifier = dataSetIdentifier;
    }

    public String getDataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public InsightVisual withDataSetIdentifier(String dataSetIdentifier) {
        this.setDataSetIdentifier(dataSetIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVisualId() != null) {
            sb.append("VisualId: ").append(this.getVisualId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getSubtitle() != null) {
            sb.append("Subtitle: ").append(this.getSubtitle()).append(",");
        }
        if (this.getInsightConfiguration() != null) {
            sb.append("InsightConfiguration: ").append(this.getInsightConfiguration()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getDataSetIdentifier() != null) {
            sb.append("DataSetIdentifier: ").append(this.getDataSetIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightVisual)) {
            return false;
        }
        InsightVisual other = (InsightVisual)obj;
        if (other.getVisualId() == null ^ this.getVisualId() == null) {
            return false;
        }
        if (other.getVisualId() != null && !other.getVisualId().equals(this.getVisualId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getSubtitle() == null ^ this.getSubtitle() == null) {
            return false;
        }
        if (other.getSubtitle() != null && !other.getSubtitle().equals(this.getSubtitle())) {
            return false;
        }
        if (other.getInsightConfiguration() == null ^ this.getInsightConfiguration() == null) {
            return false;
        }
        if (other.getInsightConfiguration() != null && !other.getInsightConfiguration().equals(this.getInsightConfiguration())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getDataSetIdentifier() == null ^ this.getDataSetIdentifier() == null) {
            return false;
        }
        return other.getDataSetIdentifier() == null || other.getDataSetIdentifier().equals(this.getDataSetIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVisualId() == null ? 0 : this.getVisualId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getSubtitle() == null ? 0 : this.getSubtitle().hashCode());
        hashCode = 31 * hashCode + (this.getInsightConfiguration() == null ? 0 : this.getInsightConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetIdentifier() == null ? 0 : this.getDataSetIdentifier().hashCode());
        return hashCode;
    }

    public InsightVisual clone() {
        try {
            return (InsightVisual)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightVisualMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

