/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.BarChartConfiguration;
import com.amazonaws.services.quicksight.model.ColumnHierarchy;
import com.amazonaws.services.quicksight.model.VisualCustomAction;
import com.amazonaws.services.quicksight.model.VisualSubtitleLabelOptions;
import com.amazonaws.services.quicksight.model.VisualTitleLabelOptions;
import com.amazonaws.services.quicksight.model.transform.BarChartVisualMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BarChartVisual
implements Serializable,
Cloneable,
StructuredPojo {
    private String visualId;
    private VisualTitleLabelOptions title;
    private VisualSubtitleLabelOptions subtitle;
    private BarChartConfiguration chartConfiguration;
    private List<VisualCustomAction> actions;
    private List<ColumnHierarchy> columnHierarchies;

    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }

    public String getVisualId() {
        return this.visualId;
    }

    public BarChartVisual withVisualId(String visualId) {
        this.setVisualId(visualId);
        return this;
    }

    public void setTitle(VisualTitleLabelOptions title) {
        this.title = title;
    }

    public VisualTitleLabelOptions getTitle() {
        return this.title;
    }

    public BarChartVisual withTitle(VisualTitleLabelOptions title) {
        this.setTitle(title);
        return this;
    }

    public void setSubtitle(VisualSubtitleLabelOptions subtitle) {
        this.subtitle = subtitle;
    }

    public VisualSubtitleLabelOptions getSubtitle() {
        return this.subtitle;
    }

    public BarChartVisual withSubtitle(VisualSubtitleLabelOptions subtitle) {
        this.setSubtitle(subtitle);
        return this;
    }

    public void setChartConfiguration(BarChartConfiguration chartConfiguration) {
        this.chartConfiguration = chartConfiguration;
    }

    public BarChartConfiguration getChartConfiguration() {
        return this.chartConfiguration;
    }

    public BarChartVisual withChartConfiguration(BarChartConfiguration chartConfiguration) {
        this.setChartConfiguration(chartConfiguration);
        return this;
    }

    public List<VisualCustomAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<VisualCustomAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<VisualCustomAction>(actions);
    }

    public BarChartVisual withActions(VisualCustomAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<VisualCustomAction>(actions.length));
        }
        for (VisualCustomAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public BarChartVisual withActions(Collection<VisualCustomAction> actions) {
        this.setActions(actions);
        return this;
    }

    public List<ColumnHierarchy> getColumnHierarchies() {
        return this.columnHierarchies;
    }

    public void setColumnHierarchies(Collection<ColumnHierarchy> columnHierarchies) {
        if (columnHierarchies == null) {
            this.columnHierarchies = null;
            return;
        }
        this.columnHierarchies = new ArrayList<ColumnHierarchy>(columnHierarchies);
    }

    public BarChartVisual withColumnHierarchies(ColumnHierarchy ... columnHierarchies) {
        if (this.columnHierarchies == null) {
            this.setColumnHierarchies(new ArrayList<ColumnHierarchy>(columnHierarchies.length));
        }
        for (ColumnHierarchy ele : columnHierarchies) {
            this.columnHierarchies.add(ele);
        }
        return this;
    }

    public BarChartVisual withColumnHierarchies(Collection<ColumnHierarchy> columnHierarchies) {
        this.setColumnHierarchies(columnHierarchies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVisualId() != null) {
            sb.append("VisualId: ").append(this.getVisualId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getSubtitle() != null) {
            sb.append("Subtitle: ").append(this.getSubtitle()).append(",");
        }
        if (this.getChartConfiguration() != null) {
            sb.append("ChartConfiguration: ").append(this.getChartConfiguration()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getColumnHierarchies() != null) {
            sb.append("ColumnHierarchies: ").append(this.getColumnHierarchies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartVisual)) {
            return false;
        }
        BarChartVisual other = (BarChartVisual)obj;
        if (other.getVisualId() == null ^ this.getVisualId() == null) {
            return false;
        }
        if (other.getVisualId() != null && !other.getVisualId().equals(this.getVisualId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getSubtitle() == null ^ this.getSubtitle() == null) {
            return false;
        }
        if (other.getSubtitle() != null && !other.getSubtitle().equals(this.getSubtitle())) {
            return false;
        }
        if (other.getChartConfiguration() == null ^ this.getChartConfiguration() == null) {
            return false;
        }
        if (other.getChartConfiguration() != null && !other.getChartConfiguration().equals(this.getChartConfiguration())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getColumnHierarchies() == null ^ this.getColumnHierarchies() == null) {
            return false;
        }
        return other.getColumnHierarchies() == null || other.getColumnHierarchies().equals(this.getColumnHierarchies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVisualId() == null ? 0 : this.getVisualId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getSubtitle() == null ? 0 : this.getSubtitle().hashCode());
        hashCode = 31 * hashCode + (this.getChartConfiguration() == null ? 0 : this.getChartConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getColumnHierarchies() == null ? 0 : this.getColumnHierarchies().hashCode());
        return hashCode;
    }

    public BarChartVisual clone() {
        try {
            return (BarChartVisual)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BarChartVisualMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

