/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.S3;
import com.amazonaws.services.qbusiness.model.transform.DocumentContentMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DocumentContent
implements Serializable,
Cloneable,
StructuredPojo {
    private ByteBuffer blob;
    private S3 s3;

    public void setBlob(ByteBuffer blob) {
        this.blob = blob;
    }

    public ByteBuffer getBlob() {
        return this.blob;
    }

    public DocumentContent withBlob(ByteBuffer blob) {
        this.setBlob(blob);
        return this;
    }

    public void setS3(S3 s3) {
        this.s3 = s3;
    }

    public S3 getS3() {
        return this.s3;
    }

    public DocumentContent withS3(S3 s3) {
        this.setS3(s3);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlob() != null) {
            sb.append("Blob: ").append(this.getBlob()).append(",");
        }
        if (this.getS3() != null) {
            sb.append("S3: ").append(this.getS3());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentContent)) {
            return false;
        }
        DocumentContent other = (DocumentContent)obj;
        if (other.getBlob() == null ^ this.getBlob() == null) {
            return false;
        }
        if (other.getBlob() != null && !other.getBlob().equals(this.getBlob())) {
            return false;
        }
        if (other.getS3() == null ^ this.getS3() == null) {
            return false;
        }
        return other.getS3() == null || other.getS3().equals(this.getS3());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlob() == null ? 0 : this.getBlob().hashCode());
        hashCode = 31 * hashCode + (this.getS3() == null ? 0 : this.getS3().hashCode());
        return hashCode;
    }

    public DocumentContent clone() {
        try {
            return (DocumentContent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentContentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

