/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.personalize.model.MetricAttribute;
import com.amazonaws.services.personalize.model.MetricAttributionOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMetricAttributionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String datasetGroupArn;
    private List<MetricAttribute> metrics;
    private MetricAttributionOutput metricsOutputConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateMetricAttributionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDatasetGroupArn(String datasetGroupArn) {
        this.datasetGroupArn = datasetGroupArn;
    }

    public String getDatasetGroupArn() {
        return this.datasetGroupArn;
    }

    public CreateMetricAttributionRequest withDatasetGroupArn(String datasetGroupArn) {
        this.setDatasetGroupArn(datasetGroupArn);
        return this;
    }

    public List<MetricAttribute> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<MetricAttribute> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new ArrayList<MetricAttribute>(metrics);
    }

    public CreateMetricAttributionRequest withMetrics(MetricAttribute ... metrics) {
        if (this.metrics == null) {
            this.setMetrics(new ArrayList<MetricAttribute>(metrics.length));
        }
        for (MetricAttribute ele : metrics) {
            this.metrics.add(ele);
        }
        return this;
    }

    public CreateMetricAttributionRequest withMetrics(Collection<MetricAttribute> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public void setMetricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
        this.metricsOutputConfig = metricsOutputConfig;
    }

    public MetricAttributionOutput getMetricsOutputConfig() {
        return this.metricsOutputConfig;
    }

    public CreateMetricAttributionRequest withMetricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
        this.setMetricsOutputConfig(metricsOutputConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDatasetGroupArn() != null) {
            sb.append("DatasetGroupArn: ").append(this.getDatasetGroupArn()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getMetricsOutputConfig() != null) {
            sb.append("MetricsOutputConfig: ").append(this.getMetricsOutputConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetricAttributionRequest)) {
            return false;
        }
        CreateMetricAttributionRequest other = (CreateMetricAttributionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDatasetGroupArn() == null ^ this.getDatasetGroupArn() == null) {
            return false;
        }
        if (other.getDatasetGroupArn() != null && !other.getDatasetGroupArn().equals(this.getDatasetGroupArn())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getMetricsOutputConfig() == null ^ this.getMetricsOutputConfig() == null) {
            return false;
        }
        return other.getMetricsOutputConfig() == null || other.getMetricsOutputConfig().equals(this.getMetricsOutputConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetGroupArn() == null ? 0 : this.getDatasetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getMetricsOutputConfig() == null ? 0 : this.getMetricsOutputConfig().hashCode());
        return hashCode;
    }

    public CreateMetricAttributionRequest clone() {
        return (CreateMetricAttributionRequest)super.clone();
    }
}

