/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.WindowStartTime;

@SdkInternalApi
public class WindowStartTimeMarshaller {
    private static final MarshallingInfo<Long> HOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hours").build();
    private static final MarshallingInfo<Long> MINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Minutes").build();
    private static final WindowStartTimeMarshaller instance = new WindowStartTimeMarshaller();

    public static WindowStartTimeMarshaller getInstance() {
        return instance;
    }

    public void marshall(WindowStartTime windowStartTime, ProtocolMarshaller protocolMarshaller) {
        if (windowStartTime == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)windowStartTime.getHours(), HOURS_BINDING);
            protocolMarshaller.marshall((Object)windowStartTime.getMinutes(), MINUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

