/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.PackageDetails;
import java.util.Date;

@SdkInternalApi
public class PackageDetailsMarshaller {
    private static final MarshallingInfo<String> PACKAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageID").build();
    private static final MarshallingInfo<String> PACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageName").build();
    private static final MarshallingInfo<String> PACKAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageType").build();
    private static final MarshallingInfo<String> PACKAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageDescription").build();
    private static final MarshallingInfo<String> PACKAGESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageStatus").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> AVAILABLEPACKAGEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailablePackageVersion").build();
    private static final MarshallingInfo<StructuredPojo> ERRORDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorDetails").build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").build();
    private static final MarshallingInfo<StructuredPojo> AVAILABLEPLUGINPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailablePluginProperties").build();
    private static final PackageDetailsMarshaller instance = new PackageDetailsMarshaller();

    public static PackageDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageDetails packageDetails, ProtocolMarshaller protocolMarshaller) {
        if (packageDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)packageDetails.getPackageID(), PACKAGEID_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getPackageName(), PACKAGENAME_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getPackageType(), PACKAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getPackageDescription(), PACKAGEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getPackageStatus(), PACKAGESTATUS_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getAvailablePackageVersion(), AVAILABLEPACKAGEVERSION_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getErrorDetails(), ERRORDETAILS_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getEngineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)packageDetails.getAvailablePluginProperties(), AVAILABLEPLUGINPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

