/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.opensearch.model.DataSourceDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDataSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DataSourceDetails> dataSources;

    public List<DataSourceDetails> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSourceDetails> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<DataSourceDetails>(dataSources);
    }

    public ListDataSourcesResult withDataSources(DataSourceDetails ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<DataSourceDetails>(dataSources.length));
        }
        for (DataSourceDetails ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public ListDataSourcesResult withDataSources(Collection<DataSourceDetails> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResult)) {
            return false;
        }
        ListDataSourcesResult other = (ListDataSourcesResult)obj;
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        return other.getDataSources() == null || other.getDataSources().equals(this.getDataSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        return hashCode;
    }

    public ListDataSourcesResult clone() {
        try {
            return (ListDataSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

