/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.neptunedata.model.IllegalArgumentException;
import com.amazonaws.services.neptunedata.model.SparqlRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetSparqlStreamResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Map<String, String> lastEventId;
    private Long lastTrxTimestampInMillis;
    private String format;
    private List<SparqlRecord> records;
    private Integer totalRecords;

    public Map<String, String> getLastEventId() {
        return this.lastEventId;
    }

    public void setLastEventId(Map<String, String> lastEventId) {
        this.lastEventId = lastEventId;
    }

    public GetSparqlStreamResult withLastEventId(Map<String, String> lastEventId) {
        this.setLastEventId(lastEventId);
        return this;
    }

    public GetSparqlStreamResult addLastEventIdEntry(String key, String value) {
        if (null == this.lastEventId) {
            this.lastEventId = new HashMap<String, String>();
        }
        if (this.lastEventId.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.lastEventId.put(key, value);
        return this;
    }

    public GetSparqlStreamResult clearLastEventIdEntries() {
        this.lastEventId = null;
        return this;
    }

    public void setLastTrxTimestampInMillis(Long lastTrxTimestampInMillis) {
        this.lastTrxTimestampInMillis = lastTrxTimestampInMillis;
    }

    public Long getLastTrxTimestampInMillis() {
        return this.lastTrxTimestampInMillis;
    }

    public GetSparqlStreamResult withLastTrxTimestampInMillis(Long lastTrxTimestampInMillis) {
        this.setLastTrxTimestampInMillis(lastTrxTimestampInMillis);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public GetSparqlStreamResult withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public List<SparqlRecord> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<SparqlRecord> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new ArrayList<SparqlRecord>(records);
    }

    public GetSparqlStreamResult withRecords(SparqlRecord ... records) {
        if (this.records == null) {
            this.setRecords(new ArrayList<SparqlRecord>(records.length));
        }
        for (SparqlRecord ele : records) {
            this.records.add(ele);
        }
        return this;
    }

    public GetSparqlStreamResult withRecords(Collection<SparqlRecord> records) {
        this.setRecords(records);
        return this;
    }

    public void setTotalRecords(Integer totalRecords) {
        this.totalRecords = totalRecords;
    }

    public Integer getTotalRecords() {
        return this.totalRecords;
    }

    public GetSparqlStreamResult withTotalRecords(Integer totalRecords) {
        this.setTotalRecords(totalRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLastEventId() != null) {
            sb.append("LastEventId: ").append(this.getLastEventId()).append(",");
        }
        if (this.getLastTrxTimestampInMillis() != null) {
            sb.append("LastTrxTimestampInMillis: ").append(this.getLastTrxTimestampInMillis()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords()).append(",");
        }
        if (this.getTotalRecords() != null) {
            sb.append("TotalRecords: ").append(this.getTotalRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSparqlStreamResult)) {
            return false;
        }
        GetSparqlStreamResult other = (GetSparqlStreamResult)obj;
        if (other.getLastEventId() == null ^ this.getLastEventId() == null) {
            return false;
        }
        if (other.getLastEventId() != null && !other.getLastEventId().equals(this.getLastEventId())) {
            return false;
        }
        if (other.getLastTrxTimestampInMillis() == null ^ this.getLastTrxTimestampInMillis() == null) {
            return false;
        }
        if (other.getLastTrxTimestampInMillis() != null && !other.getLastTrxTimestampInMillis().equals(this.getLastTrxTimestampInMillis())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getTotalRecords() == null ^ this.getTotalRecords() == null) {
            return false;
        }
        return other.getTotalRecords() == null || other.getTotalRecords().equals(this.getTotalRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLastEventId() == null ? 0 : this.getLastEventId().hashCode());
        hashCode = 31 * hashCode + (this.getLastTrxTimestampInMillis() == null ? 0 : this.getLastTrxTimestampInMillis().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getTotalRecords() == null ? 0 : this.getTotalRecords().hashCode());
        return hashCode;
    }

    public GetSparqlStreamResult clone() {
        try {
            return (GetSparqlStreamResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

