/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medicalimaging;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.medicalimaging.AWSMedicalImagingAsync;
import com.amazonaws.services.medicalimaging.AWSMedicalImagingAsyncClientBuilder;
import com.amazonaws.services.medicalimaging.AWSMedicalImagingClient;
import com.amazonaws.services.medicalimaging.model.CopyImageSetRequest;
import com.amazonaws.services.medicalimaging.model.CopyImageSetResult;
import com.amazonaws.services.medicalimaging.model.CreateDatastoreRequest;
import com.amazonaws.services.medicalimaging.model.CreateDatastoreResult;
import com.amazonaws.services.medicalimaging.model.DeleteDatastoreRequest;
import com.amazonaws.services.medicalimaging.model.DeleteDatastoreResult;
import com.amazonaws.services.medicalimaging.model.DeleteImageSetRequest;
import com.amazonaws.services.medicalimaging.model.DeleteImageSetResult;
import com.amazonaws.services.medicalimaging.model.GetDICOMImportJobRequest;
import com.amazonaws.services.medicalimaging.model.GetDICOMImportJobResult;
import com.amazonaws.services.medicalimaging.model.GetDatastoreRequest;
import com.amazonaws.services.medicalimaging.model.GetDatastoreResult;
import com.amazonaws.services.medicalimaging.model.GetImageFrameRequest;
import com.amazonaws.services.medicalimaging.model.GetImageFrameResult;
import com.amazonaws.services.medicalimaging.model.GetImageSetMetadataRequest;
import com.amazonaws.services.medicalimaging.model.GetImageSetMetadataResult;
import com.amazonaws.services.medicalimaging.model.GetImageSetRequest;
import com.amazonaws.services.medicalimaging.model.GetImageSetResult;
import com.amazonaws.services.medicalimaging.model.ListDICOMImportJobsRequest;
import com.amazonaws.services.medicalimaging.model.ListDICOMImportJobsResult;
import com.amazonaws.services.medicalimaging.model.ListDatastoresRequest;
import com.amazonaws.services.medicalimaging.model.ListDatastoresResult;
import com.amazonaws.services.medicalimaging.model.ListImageSetVersionsRequest;
import com.amazonaws.services.medicalimaging.model.ListImageSetVersionsResult;
import com.amazonaws.services.medicalimaging.model.ListTagsForResourceRequest;
import com.amazonaws.services.medicalimaging.model.ListTagsForResourceResult;
import com.amazonaws.services.medicalimaging.model.SearchImageSetsRequest;
import com.amazonaws.services.medicalimaging.model.SearchImageSetsResult;
import com.amazonaws.services.medicalimaging.model.StartDICOMImportJobRequest;
import com.amazonaws.services.medicalimaging.model.StartDICOMImportJobResult;
import com.amazonaws.services.medicalimaging.model.TagResourceRequest;
import com.amazonaws.services.medicalimaging.model.TagResourceResult;
import com.amazonaws.services.medicalimaging.model.UntagResourceRequest;
import com.amazonaws.services.medicalimaging.model.UntagResourceResult;
import com.amazonaws.services.medicalimaging.model.UpdateImageSetMetadataRequest;
import com.amazonaws.services.medicalimaging.model.UpdateImageSetMetadataResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMedicalImagingAsyncClient
extends AWSMedicalImagingClient
implements AWSMedicalImagingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMedicalImagingAsyncClientBuilder asyncBuilder() {
        return AWSMedicalImagingAsyncClientBuilder.standard();
    }

    AWSMedicalImagingAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMedicalImagingAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CopyImageSetResult> copyImageSetAsync(CopyImageSetRequest request) {
        return this.copyImageSetAsync(request, null);
    }

    @Override
    public Future<CopyImageSetResult> copyImageSetAsync(CopyImageSetRequest request, final AsyncHandler<CopyImageSetRequest, CopyImageSetResult> asyncHandler) {
        final CopyImageSetRequest finalRequest = (CopyImageSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CopyImageSetResult>(){

            @Override
            public CopyImageSetResult call() throws Exception {
                CopyImageSetResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeCopyImageSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatastoreResult> createDatastoreAsync(CreateDatastoreRequest request) {
        return this.createDatastoreAsync(request, null);
    }

    @Override
    public Future<CreateDatastoreResult> createDatastoreAsync(CreateDatastoreRequest request, final AsyncHandler<CreateDatastoreRequest, CreateDatastoreResult> asyncHandler) {
        final CreateDatastoreRequest finalRequest = (CreateDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatastoreResult>(){

            @Override
            public CreateDatastoreResult call() throws Exception {
                CreateDatastoreResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeCreateDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatastoreResult> deleteDatastoreAsync(DeleteDatastoreRequest request) {
        return this.deleteDatastoreAsync(request, null);
    }

    @Override
    public Future<DeleteDatastoreResult> deleteDatastoreAsync(DeleteDatastoreRequest request, final AsyncHandler<DeleteDatastoreRequest, DeleteDatastoreResult> asyncHandler) {
        final DeleteDatastoreRequest finalRequest = (DeleteDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatastoreResult>(){

            @Override
            public DeleteDatastoreResult call() throws Exception {
                DeleteDatastoreResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeDeleteDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteImageSetResult> deleteImageSetAsync(DeleteImageSetRequest request) {
        return this.deleteImageSetAsync(request, null);
    }

    @Override
    public Future<DeleteImageSetResult> deleteImageSetAsync(DeleteImageSetRequest request, final AsyncHandler<DeleteImageSetRequest, DeleteImageSetResult> asyncHandler) {
        final DeleteImageSetRequest finalRequest = (DeleteImageSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteImageSetResult>(){

            @Override
            public DeleteImageSetResult call() throws Exception {
                DeleteImageSetResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeDeleteImageSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDICOMImportJobResult> getDICOMImportJobAsync(GetDICOMImportJobRequest request) {
        return this.getDICOMImportJobAsync(request, null);
    }

    @Override
    public Future<GetDICOMImportJobResult> getDICOMImportJobAsync(GetDICOMImportJobRequest request, final AsyncHandler<GetDICOMImportJobRequest, GetDICOMImportJobResult> asyncHandler) {
        final GetDICOMImportJobRequest finalRequest = (GetDICOMImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDICOMImportJobResult>(){

            @Override
            public GetDICOMImportJobResult call() throws Exception {
                GetDICOMImportJobResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeGetDICOMImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatastoreResult> getDatastoreAsync(GetDatastoreRequest request) {
        return this.getDatastoreAsync(request, null);
    }

    @Override
    public Future<GetDatastoreResult> getDatastoreAsync(GetDatastoreRequest request, final AsyncHandler<GetDatastoreRequest, GetDatastoreResult> asyncHandler) {
        final GetDatastoreRequest finalRequest = (GetDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatastoreResult>(){

            @Override
            public GetDatastoreResult call() throws Exception {
                GetDatastoreResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeGetDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetImageFrameResult> getImageFrameAsync(GetImageFrameRequest request) {
        return this.getImageFrameAsync(request, null);
    }

    @Override
    public Future<GetImageFrameResult> getImageFrameAsync(GetImageFrameRequest request, final AsyncHandler<GetImageFrameRequest, GetImageFrameResult> asyncHandler) {
        final GetImageFrameRequest finalRequest = (GetImageFrameRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetImageFrameResult>(){

            @Override
            public GetImageFrameResult call() throws Exception {
                GetImageFrameResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeGetImageFrame(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetImageSetResult> getImageSetAsync(GetImageSetRequest request) {
        return this.getImageSetAsync(request, null);
    }

    @Override
    public Future<GetImageSetResult> getImageSetAsync(GetImageSetRequest request, final AsyncHandler<GetImageSetRequest, GetImageSetResult> asyncHandler) {
        final GetImageSetRequest finalRequest = (GetImageSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetImageSetResult>(){

            @Override
            public GetImageSetResult call() throws Exception {
                GetImageSetResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeGetImageSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetImageSetMetadataResult> getImageSetMetadataAsync(GetImageSetMetadataRequest request) {
        return this.getImageSetMetadataAsync(request, null);
    }

    @Override
    public Future<GetImageSetMetadataResult> getImageSetMetadataAsync(GetImageSetMetadataRequest request, final AsyncHandler<GetImageSetMetadataRequest, GetImageSetMetadataResult> asyncHandler) {
        final GetImageSetMetadataRequest finalRequest = (GetImageSetMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetImageSetMetadataResult>(){

            @Override
            public GetImageSetMetadataResult call() throws Exception {
                GetImageSetMetadataResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeGetImageSetMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDICOMImportJobsResult> listDICOMImportJobsAsync(ListDICOMImportJobsRequest request) {
        return this.listDICOMImportJobsAsync(request, null);
    }

    @Override
    public Future<ListDICOMImportJobsResult> listDICOMImportJobsAsync(ListDICOMImportJobsRequest request, final AsyncHandler<ListDICOMImportJobsRequest, ListDICOMImportJobsResult> asyncHandler) {
        final ListDICOMImportJobsRequest finalRequest = (ListDICOMImportJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDICOMImportJobsResult>(){

            @Override
            public ListDICOMImportJobsResult call() throws Exception {
                ListDICOMImportJobsResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeListDICOMImportJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatastoresResult> listDatastoresAsync(ListDatastoresRequest request) {
        return this.listDatastoresAsync(request, null);
    }

    @Override
    public Future<ListDatastoresResult> listDatastoresAsync(ListDatastoresRequest request, final AsyncHandler<ListDatastoresRequest, ListDatastoresResult> asyncHandler) {
        final ListDatastoresRequest finalRequest = (ListDatastoresRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatastoresResult>(){

            @Override
            public ListDatastoresResult call() throws Exception {
                ListDatastoresResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeListDatastores(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListImageSetVersionsResult> listImageSetVersionsAsync(ListImageSetVersionsRequest request) {
        return this.listImageSetVersionsAsync(request, null);
    }

    @Override
    public Future<ListImageSetVersionsResult> listImageSetVersionsAsync(ListImageSetVersionsRequest request, final AsyncHandler<ListImageSetVersionsRequest, ListImageSetVersionsResult> asyncHandler) {
        final ListImageSetVersionsRequest finalRequest = (ListImageSetVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListImageSetVersionsResult>(){

            @Override
            public ListImageSetVersionsResult call() throws Exception {
                ListImageSetVersionsResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeListImageSetVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchImageSetsResult> searchImageSetsAsync(SearchImageSetsRequest request) {
        return this.searchImageSetsAsync(request, null);
    }

    @Override
    public Future<SearchImageSetsResult> searchImageSetsAsync(SearchImageSetsRequest request, final AsyncHandler<SearchImageSetsRequest, SearchImageSetsResult> asyncHandler) {
        final SearchImageSetsRequest finalRequest = (SearchImageSetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchImageSetsResult>(){

            @Override
            public SearchImageSetsResult call() throws Exception {
                SearchImageSetsResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeSearchImageSets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDICOMImportJobResult> startDICOMImportJobAsync(StartDICOMImportJobRequest request) {
        return this.startDICOMImportJobAsync(request, null);
    }

    @Override
    public Future<StartDICOMImportJobResult> startDICOMImportJobAsync(StartDICOMImportJobRequest request, final AsyncHandler<StartDICOMImportJobRequest, StartDICOMImportJobResult> asyncHandler) {
        final StartDICOMImportJobRequest finalRequest = (StartDICOMImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDICOMImportJobResult>(){

            @Override
            public StartDICOMImportJobResult call() throws Exception {
                StartDICOMImportJobResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeStartDICOMImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateImageSetMetadataResult> updateImageSetMetadataAsync(UpdateImageSetMetadataRequest request) {
        return this.updateImageSetMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateImageSetMetadataResult> updateImageSetMetadataAsync(UpdateImageSetMetadataRequest request, final AsyncHandler<UpdateImageSetMetadataRequest, UpdateImageSetMetadataResult> asyncHandler) {
        final UpdateImageSetMetadataRequest finalRequest = (UpdateImageSetMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateImageSetMetadataResult>(){

            @Override
            public UpdateImageSetMetadataResult call() throws Exception {
                UpdateImageSetMetadataResult result = null;
                try {
                    result = AWSMedicalImagingAsyncClient.this.executeUpdateImageSetMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

