/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.S3DestinationSettings;

@SdkInternalApi
public class S3DestinationSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACCESSCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessControl").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").build();
    private static final MarshallingInfo<String> STORAGECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storageClass").build();
    private static final S3DestinationSettingsMarshaller instance = new S3DestinationSettingsMarshaller();

    public static S3DestinationSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DestinationSettings s3DestinationSettings, ProtocolMarshaller protocolMarshaller) {
        if (s3DestinationSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3DestinationSettings.getAccessControl(), ACCESSCONTROL_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationSettings.getEncryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationSettings.getStorageClass(), STORAGECLASS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

