/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.DolbyVision;

@SdkInternalApi
public class DolbyVisionMarshaller {
    private static final MarshallingInfo<StructuredPojo> L6METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("l6Metadata").build();
    private static final MarshallingInfo<String> L6MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("l6Mode").build();
    private static final MarshallingInfo<String> MAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mapping").build();
    private static final MarshallingInfo<String> PROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("profile").build();
    private static final DolbyVisionMarshaller instance = new DolbyVisionMarshaller();

    public static DolbyVisionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DolbyVision dolbyVision, ProtocolMarshaller protocolMarshaller) {
        if (dolbyVision == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dolbyVision.getL6Metadata(), L6METADATA_BINDING);
            protocolMarshaller.marshall((Object)dolbyVision.getL6Mode(), L6MODE_BINDING);
            protocolMarshaller.marshall((Object)dolbyVision.getMapping(), MAPPING_BINDING);
            protocolMarshaller.marshall((Object)dolbyVision.getProfile(), PROFILE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

