/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.ClipLimits;
import com.amazonaws.services.mediaconvert.model.ColorSpaceConversion;
import com.amazonaws.services.mediaconvert.model.Hdr10Metadata;
import com.amazonaws.services.mediaconvert.model.SampleRangeConversion;
import com.amazonaws.services.mediaconvert.model.transform.ColorCorrectorMarshaller;
import java.io.Serializable;

public class ColorCorrector
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer brightness;
    private ClipLimits clipLimits;
    private String colorSpaceConversion;
    private Integer contrast;
    private Hdr10Metadata hdr10Metadata;
    private Integer hue;
    private String sampleRangeConversion;
    private Integer saturation;
    private Integer sdrReferenceWhiteLevel;

    public void setBrightness(Integer brightness) {
        this.brightness = brightness;
    }

    public Integer getBrightness() {
        return this.brightness;
    }

    public ColorCorrector withBrightness(Integer brightness) {
        this.setBrightness(brightness);
        return this;
    }

    public void setClipLimits(ClipLimits clipLimits) {
        this.clipLimits = clipLimits;
    }

    public ClipLimits getClipLimits() {
        return this.clipLimits;
    }

    public ColorCorrector withClipLimits(ClipLimits clipLimits) {
        this.setClipLimits(clipLimits);
        return this;
    }

    public void setColorSpaceConversion(String colorSpaceConversion) {
        this.colorSpaceConversion = colorSpaceConversion;
    }

    public String getColorSpaceConversion() {
        return this.colorSpaceConversion;
    }

    public ColorCorrector withColorSpaceConversion(String colorSpaceConversion) {
        this.setColorSpaceConversion(colorSpaceConversion);
        return this;
    }

    public ColorCorrector withColorSpaceConversion(ColorSpaceConversion colorSpaceConversion) {
        this.colorSpaceConversion = colorSpaceConversion.toString();
        return this;
    }

    public void setContrast(Integer contrast) {
        this.contrast = contrast;
    }

    public Integer getContrast() {
        return this.contrast;
    }

    public ColorCorrector withContrast(Integer contrast) {
        this.setContrast(contrast);
        return this;
    }

    public void setHdr10Metadata(Hdr10Metadata hdr10Metadata) {
        this.hdr10Metadata = hdr10Metadata;
    }

    public Hdr10Metadata getHdr10Metadata() {
        return this.hdr10Metadata;
    }

    public ColorCorrector withHdr10Metadata(Hdr10Metadata hdr10Metadata) {
        this.setHdr10Metadata(hdr10Metadata);
        return this;
    }

    public void setHue(Integer hue) {
        this.hue = hue;
    }

    public Integer getHue() {
        return this.hue;
    }

    public ColorCorrector withHue(Integer hue) {
        this.setHue(hue);
        return this;
    }

    public void setSampleRangeConversion(String sampleRangeConversion) {
        this.sampleRangeConversion = sampleRangeConversion;
    }

    public String getSampleRangeConversion() {
        return this.sampleRangeConversion;
    }

    public ColorCorrector withSampleRangeConversion(String sampleRangeConversion) {
        this.setSampleRangeConversion(sampleRangeConversion);
        return this;
    }

    public ColorCorrector withSampleRangeConversion(SampleRangeConversion sampleRangeConversion) {
        this.sampleRangeConversion = sampleRangeConversion.toString();
        return this;
    }

    public void setSaturation(Integer saturation) {
        this.saturation = saturation;
    }

    public Integer getSaturation() {
        return this.saturation;
    }

    public ColorCorrector withSaturation(Integer saturation) {
        this.setSaturation(saturation);
        return this;
    }

    public void setSdrReferenceWhiteLevel(Integer sdrReferenceWhiteLevel) {
        this.sdrReferenceWhiteLevel = sdrReferenceWhiteLevel;
    }

    public Integer getSdrReferenceWhiteLevel() {
        return this.sdrReferenceWhiteLevel;
    }

    public ColorCorrector withSdrReferenceWhiteLevel(Integer sdrReferenceWhiteLevel) {
        this.setSdrReferenceWhiteLevel(sdrReferenceWhiteLevel);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBrightness() != null) {
            sb.append("Brightness: ").append(this.getBrightness()).append(",");
        }
        if (this.getClipLimits() != null) {
            sb.append("ClipLimits: ").append(this.getClipLimits()).append(",");
        }
        if (this.getColorSpaceConversion() != null) {
            sb.append("ColorSpaceConversion: ").append(this.getColorSpaceConversion()).append(",");
        }
        if (this.getContrast() != null) {
            sb.append("Contrast: ").append(this.getContrast()).append(",");
        }
        if (this.getHdr10Metadata() != null) {
            sb.append("Hdr10Metadata: ").append(this.getHdr10Metadata()).append(",");
        }
        if (this.getHue() != null) {
            sb.append("Hue: ").append(this.getHue()).append(",");
        }
        if (this.getSampleRangeConversion() != null) {
            sb.append("SampleRangeConversion: ").append(this.getSampleRangeConversion()).append(",");
        }
        if (this.getSaturation() != null) {
            sb.append("Saturation: ").append(this.getSaturation()).append(",");
        }
        if (this.getSdrReferenceWhiteLevel() != null) {
            sb.append("SdrReferenceWhiteLevel: ").append(this.getSdrReferenceWhiteLevel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrector)) {
            return false;
        }
        ColorCorrector other = (ColorCorrector)obj;
        if (other.getBrightness() == null ^ this.getBrightness() == null) {
            return false;
        }
        if (other.getBrightness() != null && !other.getBrightness().equals(this.getBrightness())) {
            return false;
        }
        if (other.getClipLimits() == null ^ this.getClipLimits() == null) {
            return false;
        }
        if (other.getClipLimits() != null && !other.getClipLimits().equals(this.getClipLimits())) {
            return false;
        }
        if (other.getColorSpaceConversion() == null ^ this.getColorSpaceConversion() == null) {
            return false;
        }
        if (other.getColorSpaceConversion() != null && !other.getColorSpaceConversion().equals(this.getColorSpaceConversion())) {
            return false;
        }
        if (other.getContrast() == null ^ this.getContrast() == null) {
            return false;
        }
        if (other.getContrast() != null && !other.getContrast().equals(this.getContrast())) {
            return false;
        }
        if (other.getHdr10Metadata() == null ^ this.getHdr10Metadata() == null) {
            return false;
        }
        if (other.getHdr10Metadata() != null && !other.getHdr10Metadata().equals(this.getHdr10Metadata())) {
            return false;
        }
        if (other.getHue() == null ^ this.getHue() == null) {
            return false;
        }
        if (other.getHue() != null && !other.getHue().equals(this.getHue())) {
            return false;
        }
        if (other.getSampleRangeConversion() == null ^ this.getSampleRangeConversion() == null) {
            return false;
        }
        if (other.getSampleRangeConversion() != null && !other.getSampleRangeConversion().equals(this.getSampleRangeConversion())) {
            return false;
        }
        if (other.getSaturation() == null ^ this.getSaturation() == null) {
            return false;
        }
        if (other.getSaturation() != null && !other.getSaturation().equals(this.getSaturation())) {
            return false;
        }
        if (other.getSdrReferenceWhiteLevel() == null ^ this.getSdrReferenceWhiteLevel() == null) {
            return false;
        }
        return other.getSdrReferenceWhiteLevel() == null || other.getSdrReferenceWhiteLevel().equals(this.getSdrReferenceWhiteLevel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBrightness() == null ? 0 : this.getBrightness().hashCode());
        hashCode = 31 * hashCode + (this.getClipLimits() == null ? 0 : this.getClipLimits().hashCode());
        hashCode = 31 * hashCode + (this.getColorSpaceConversion() == null ? 0 : this.getColorSpaceConversion().hashCode());
        hashCode = 31 * hashCode + (this.getContrast() == null ? 0 : this.getContrast().hashCode());
        hashCode = 31 * hashCode + (this.getHdr10Metadata() == null ? 0 : this.getHdr10Metadata().hashCode());
        hashCode = 31 * hashCode + (this.getHue() == null ? 0 : this.getHue().hashCode());
        hashCode = 31 * hashCode + (this.getSampleRangeConversion() == null ? 0 : this.getSampleRangeConversion().hashCode());
        hashCode = 31 * hashCode + (this.getSaturation() == null ? 0 : this.getSaturation().hashCode());
        hashCode = 31 * hashCode + (this.getSdrReferenceWhiteLevel() == null ? 0 : this.getSdrReferenceWhiteLevel().hashCode());
        return hashCode;
    }

    public ColorCorrector clone() {
        try {
            return (ColorCorrector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColorCorrectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

