/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.Fmtp;

@SdkInternalApi
public class FmtpMarshaller {
    private static final MarshallingInfo<String> CHANNELORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelOrder").build();
    private static final MarshallingInfo<String> COLORIMETRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorimetry").build();
    private static final MarshallingInfo<String> EXACTFRAMERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exactFramerate").build();
    private static final MarshallingInfo<String> PAR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("par").build();
    private static final MarshallingInfo<String> RANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("range").build();
    private static final MarshallingInfo<String> SCANMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanMode").build();
    private static final MarshallingInfo<String> TCS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tcs").build();
    private static final FmtpMarshaller instance = new FmtpMarshaller();

    public static FmtpMarshaller getInstance() {
        return instance;
    }

    public void marshall(Fmtp fmtp, ProtocolMarshaller protocolMarshaller) {
        if (fmtp == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fmtp.getChannelOrder(), CHANNELORDER_BINDING);
            protocolMarshaller.marshall((Object)fmtp.getColorimetry(), COLORIMETRY_BINDING);
            protocolMarshaller.marshall((Object)fmtp.getExactFramerate(), EXACTFRAMERATE_BINDING);
            protocolMarshaller.marshall((Object)fmtp.getPar(), PAR_BINDING);
            protocolMarshaller.marshall((Object)fmtp.getRange(), RANGE_BINDING);
            protocolMarshaller.marshall((Object)fmtp.getScanMode(), SCANMODE_BINDING);
            protocolMarshaller.marshall((Object)fmtp.getTcs(), TCS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

