/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mailmanager.model.SearchSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListArchiveSearchesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<SearchSummary> searches;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListArchiveSearchesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SearchSummary> getSearches() {
        return this.searches;
    }

    public void setSearches(Collection<SearchSummary> searches) {
        if (searches == null) {
            this.searches = null;
            return;
        }
        this.searches = new ArrayList<SearchSummary>(searches);
    }

    public ListArchiveSearchesResult withSearches(SearchSummary ... searches) {
        if (this.searches == null) {
            this.setSearches(new ArrayList<SearchSummary>(searches.length));
        }
        for (SearchSummary ele : searches) {
            this.searches.add(ele);
        }
        return this;
    }

    public ListArchiveSearchesResult withSearches(Collection<SearchSummary> searches) {
        this.setSearches(searches);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSearches() != null) {
            sb.append("Searches: ").append(this.getSearches());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveSearchesResult)) {
            return false;
        }
        ListArchiveSearchesResult other = (ListArchiveSearchesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSearches() == null ^ this.getSearches() == null) {
            return false;
        }
        return other.getSearches() == null || other.getSearches().equals(this.getSearches());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSearches() == null ? 0 : this.getSearches().hashCode());
        return hashCode;
    }

    public ListArchiveSearchesResult clone() {
        try {
            return (ListArchiveSearchesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

