/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.DeviceState;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DeviceStateMarshaller {
    private static final MarshallingInfo<String> DEVICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceId").build();
    private static final MarshallingInfo<Date> SAMPLETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<List> POSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Position").build();
    private static final MarshallingInfo<StructuredPojo> ACCURACY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Accuracy").build();
    private static final MarshallingInfo<String> IPV4ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ipv4Address").build();
    private static final MarshallingInfo<List> WIFIACCESSPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WiFiAccessPoints").build();
    private static final MarshallingInfo<StructuredPojo> CELLSIGNALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CellSignals").build();
    private static final DeviceStateMarshaller instance = new DeviceStateMarshaller();

    public static DeviceStateMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceState deviceState, ProtocolMarshaller protocolMarshaller) {
        if (deviceState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deviceState.getDeviceId(), DEVICEID_BINDING);
            protocolMarshaller.marshall((Object)deviceState.getSampleTime(), SAMPLETIME_BINDING);
            protocolMarshaller.marshall(deviceState.getPosition(), POSITION_BINDING);
            protocolMarshaller.marshall((Object)deviceState.getAccuracy(), ACCURACY_BINDING);
            protocolMarshaller.marshall((Object)deviceState.getIpv4Address(), IPV4ADDRESS_BINDING);
            protocolMarshaller.marshall(deviceState.getWiFiAccessPoints(), WIFIACCESSPOINTS_BINDING);
            protocolMarshaller.marshall((Object)deviceState.getCellSignals(), CELLSIGNALS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

