/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.ForecastedGeofenceEventType;
import com.amazonaws.services.location.model.transform.ForecastedEventMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ForecastedEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventId;
    private String geofenceId;
    private Boolean isDeviceInGeofence;
    private Double nearestDistance;
    private String eventType;
    private Date forecastedBreachTime;
    private Map<String, String> geofenceProperties;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public ForecastedEvent withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setGeofenceId(String geofenceId) {
        this.geofenceId = geofenceId;
    }

    public String getGeofenceId() {
        return this.geofenceId;
    }

    public ForecastedEvent withGeofenceId(String geofenceId) {
        this.setGeofenceId(geofenceId);
        return this;
    }

    public void setIsDeviceInGeofence(Boolean isDeviceInGeofence) {
        this.isDeviceInGeofence = isDeviceInGeofence;
    }

    public Boolean getIsDeviceInGeofence() {
        return this.isDeviceInGeofence;
    }

    public ForecastedEvent withIsDeviceInGeofence(Boolean isDeviceInGeofence) {
        this.setIsDeviceInGeofence(isDeviceInGeofence);
        return this;
    }

    public Boolean isDeviceInGeofence() {
        return this.isDeviceInGeofence;
    }

    public void setNearestDistance(Double nearestDistance) {
        this.nearestDistance = nearestDistance;
    }

    public Double getNearestDistance() {
        return this.nearestDistance;
    }

    public ForecastedEvent withNearestDistance(Double nearestDistance) {
        this.setNearestDistance(nearestDistance);
        return this;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public ForecastedEvent withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public ForecastedEvent withEventType(ForecastedGeofenceEventType eventType) {
        this.eventType = eventType.toString();
        return this;
    }

    public void setForecastedBreachTime(Date forecastedBreachTime) {
        this.forecastedBreachTime = forecastedBreachTime;
    }

    public Date getForecastedBreachTime() {
        return this.forecastedBreachTime;
    }

    public ForecastedEvent withForecastedBreachTime(Date forecastedBreachTime) {
        this.setForecastedBreachTime(forecastedBreachTime);
        return this;
    }

    public Map<String, String> getGeofenceProperties() {
        return this.geofenceProperties;
    }

    public void setGeofenceProperties(Map<String, String> geofenceProperties) {
        this.geofenceProperties = geofenceProperties;
    }

    public ForecastedEvent withGeofenceProperties(Map<String, String> geofenceProperties) {
        this.setGeofenceProperties(geofenceProperties);
        return this;
    }

    public ForecastedEvent addGeofencePropertiesEntry(String key, String value) {
        if (null == this.geofenceProperties) {
            this.geofenceProperties = new HashMap<String, String>();
        }
        if (this.geofenceProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.geofenceProperties.put(key, value);
        return this;
    }

    public ForecastedEvent clearGeofencePropertiesEntries() {
        this.geofenceProperties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getGeofenceId() != null) {
            sb.append("GeofenceId: ").append(this.getGeofenceId()).append(",");
        }
        if (this.getIsDeviceInGeofence() != null) {
            sb.append("IsDeviceInGeofence: ").append(this.getIsDeviceInGeofence()).append(",");
        }
        if (this.getNearestDistance() != null) {
            sb.append("NearestDistance: ").append(this.getNearestDistance()).append(",");
        }
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getForecastedBreachTime() != null) {
            sb.append("ForecastedBreachTime: ").append(this.getForecastedBreachTime()).append(",");
        }
        if (this.getGeofenceProperties() != null) {
            sb.append("GeofenceProperties: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastedEvent)) {
            return false;
        }
        ForecastedEvent other = (ForecastedEvent)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getGeofenceId() == null ^ this.getGeofenceId() == null) {
            return false;
        }
        if (other.getGeofenceId() != null && !other.getGeofenceId().equals(this.getGeofenceId())) {
            return false;
        }
        if (other.getIsDeviceInGeofence() == null ^ this.getIsDeviceInGeofence() == null) {
            return false;
        }
        if (other.getIsDeviceInGeofence() != null && !other.getIsDeviceInGeofence().equals(this.getIsDeviceInGeofence())) {
            return false;
        }
        if (other.getNearestDistance() == null ^ this.getNearestDistance() == null) {
            return false;
        }
        if (other.getNearestDistance() != null && !other.getNearestDistance().equals(this.getNearestDistance())) {
            return false;
        }
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getForecastedBreachTime() == null ^ this.getForecastedBreachTime() == null) {
            return false;
        }
        if (other.getForecastedBreachTime() != null && !other.getForecastedBreachTime().equals(this.getForecastedBreachTime())) {
            return false;
        }
        if (other.getGeofenceProperties() == null ^ this.getGeofenceProperties() == null) {
            return false;
        }
        return other.getGeofenceProperties() == null || other.getGeofenceProperties().equals(this.getGeofenceProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getGeofenceId() == null ? 0 : this.getGeofenceId().hashCode());
        hashCode = 31 * hashCode + (this.getIsDeviceInGeofence() == null ? 0 : this.getIsDeviceInGeofence().hashCode());
        hashCode = 31 * hashCode + (this.getNearestDistance() == null ? 0 : this.getNearestDistance().hashCode());
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getForecastedBreachTime() == null ? 0 : this.getForecastedBreachTime().hashCode());
        hashCode = 31 * hashCode + (this.getGeofenceProperties() == null ? 0 : this.getGeofenceProperties().hashCode());
        return hashCode;
    }

    public ForecastedEvent clone() {
        try {
            return (ForecastedEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ForecastedEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

