/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.location.model.DistanceUnit;
import com.amazonaws.services.location.model.ForecastedEvent;
import com.amazonaws.services.location.model.SpeedUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ForecastGeofenceEventsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ForecastedEvent> forecastedEvents;
    private String nextToken;
    private String distanceUnit;
    private String speedUnit;

    public List<ForecastedEvent> getForecastedEvents() {
        return this.forecastedEvents;
    }

    public void setForecastedEvents(Collection<ForecastedEvent> forecastedEvents) {
        if (forecastedEvents == null) {
            this.forecastedEvents = null;
            return;
        }
        this.forecastedEvents = new ArrayList<ForecastedEvent>(forecastedEvents);
    }

    public ForecastGeofenceEventsResult withForecastedEvents(ForecastedEvent ... forecastedEvents) {
        if (this.forecastedEvents == null) {
            this.setForecastedEvents(new ArrayList<ForecastedEvent>(forecastedEvents.length));
        }
        for (ForecastedEvent ele : forecastedEvents) {
            this.forecastedEvents.add(ele);
        }
        return this;
    }

    public ForecastGeofenceEventsResult withForecastedEvents(Collection<ForecastedEvent> forecastedEvents) {
        this.setForecastedEvents(forecastedEvents);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ForecastGeofenceEventsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setDistanceUnit(String distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public String getDistanceUnit() {
        return this.distanceUnit;
    }

    public ForecastGeofenceEventsResult withDistanceUnit(String distanceUnit) {
        this.setDistanceUnit(distanceUnit);
        return this;
    }

    public ForecastGeofenceEventsResult withDistanceUnit(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit.toString();
        return this;
    }

    public void setSpeedUnit(String speedUnit) {
        this.speedUnit = speedUnit;
    }

    public String getSpeedUnit() {
        return this.speedUnit;
    }

    public ForecastGeofenceEventsResult withSpeedUnit(String speedUnit) {
        this.setSpeedUnit(speedUnit);
        return this;
    }

    public ForecastGeofenceEventsResult withSpeedUnit(SpeedUnit speedUnit) {
        this.speedUnit = speedUnit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getForecastedEvents() != null) {
            sb.append("ForecastedEvents: ").append(this.getForecastedEvents()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getDistanceUnit() != null) {
            sb.append("DistanceUnit: ").append(this.getDistanceUnit()).append(",");
        }
        if (this.getSpeedUnit() != null) {
            sb.append("SpeedUnit: ").append(this.getSpeedUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastGeofenceEventsResult)) {
            return false;
        }
        ForecastGeofenceEventsResult other = (ForecastGeofenceEventsResult)obj;
        if (other.getForecastedEvents() == null ^ this.getForecastedEvents() == null) {
            return false;
        }
        if (other.getForecastedEvents() != null && !other.getForecastedEvents().equals(this.getForecastedEvents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getDistanceUnit() == null ^ this.getDistanceUnit() == null) {
            return false;
        }
        if (other.getDistanceUnit() != null && !other.getDistanceUnit().equals(this.getDistanceUnit())) {
            return false;
        }
        if (other.getSpeedUnit() == null ^ this.getSpeedUnit() == null) {
            return false;
        }
        return other.getSpeedUnit() == null || other.getSpeedUnit().equals(this.getSpeedUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getForecastedEvents() == null ? 0 : this.getForecastedEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getDistanceUnit() == null ? 0 : this.getDistanceUnit().hashCode());
        hashCode = 31 * hashCode + (this.getSpeedUnit() == null ? 0 : this.getSpeedUnit().hashCode());
        return hashCode;
    }

    public ForecastGeofenceEventsResult clone() {
        try {
            return (ForecastGeofenceEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

