/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.ContactMethod;
import java.util.Date;

@SdkInternalApi
public class ContactMethodMarshaller {
    private static final MarshallingInfo<String> CONTACTENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contactEndpoint").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final ContactMethodMarshaller instance = new ContactMethodMarshaller();

    public static ContactMethodMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContactMethod contactMethod, ProtocolMarshaller protocolMarshaller) {
        if (contactMethod == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)contactMethod.getContactEndpoint(), CONTACTENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)contactMethod.getSupportCode(), SUPPORTCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

