/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.PendingMaintenanceAction;
import com.amazonaws.services.lightsail.model.PendingModifiedRelationalDatabaseValues;
import com.amazonaws.services.lightsail.model.RelationalDatabaseEndpoint;
import com.amazonaws.services.lightsail.model.RelationalDatabaseHardware;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.transform.RelationalDatabaseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RelationalDatabase
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String supportCode;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private List<Tag> tags;
    private String relationalDatabaseBlueprintId;
    private String relationalDatabaseBundleId;
    private String masterDatabaseName;
    private RelationalDatabaseHardware hardware;
    private String state;
    private String secondaryAvailabilityZone;
    private Boolean backupRetentionEnabled;
    private PendingModifiedRelationalDatabaseValues pendingModifiedValues;
    private String engine;
    private String engineVersion;
    private Date latestRestorableTime;
    private String masterUsername;
    private String parameterApplyStatus;
    private String preferredBackupWindow;
    private String preferredMaintenanceWindow;
    private Boolean publiclyAccessible;
    private RelationalDatabaseEndpoint masterEndpoint;
    private List<PendingMaintenanceAction> pendingMaintenanceActions;
    private String caCertificateIdentifier;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RelationalDatabase withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public RelationalDatabase withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public RelationalDatabase withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public RelationalDatabase withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public RelationalDatabase withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public RelationalDatabase withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public RelationalDatabase withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public RelationalDatabase withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public RelationalDatabase withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setRelationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
        this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
    }

    public String getRelationalDatabaseBlueprintId() {
        return this.relationalDatabaseBlueprintId;
    }

    public RelationalDatabase withRelationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
        this.setRelationalDatabaseBlueprintId(relationalDatabaseBlueprintId);
        return this;
    }

    public void setRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
        this.relationalDatabaseBundleId = relationalDatabaseBundleId;
    }

    public String getRelationalDatabaseBundleId() {
        return this.relationalDatabaseBundleId;
    }

    public RelationalDatabase withRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
        this.setRelationalDatabaseBundleId(relationalDatabaseBundleId);
        return this;
    }

    public void setMasterDatabaseName(String masterDatabaseName) {
        this.masterDatabaseName = masterDatabaseName;
    }

    public String getMasterDatabaseName() {
        return this.masterDatabaseName;
    }

    public RelationalDatabase withMasterDatabaseName(String masterDatabaseName) {
        this.setMasterDatabaseName(masterDatabaseName);
        return this;
    }

    public void setHardware(RelationalDatabaseHardware hardware) {
        this.hardware = hardware;
    }

    public RelationalDatabaseHardware getHardware() {
        return this.hardware;
    }

    public RelationalDatabase withHardware(RelationalDatabaseHardware hardware) {
        this.setHardware(hardware);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public RelationalDatabase withState(String state) {
        this.setState(state);
        return this;
    }

    public void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.secondaryAvailabilityZone = secondaryAvailabilityZone;
    }

    public String getSecondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public RelationalDatabase withSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.setSecondaryAvailabilityZone(secondaryAvailabilityZone);
        return this;
    }

    public void setBackupRetentionEnabled(Boolean backupRetentionEnabled) {
        this.backupRetentionEnabled = backupRetentionEnabled;
    }

    public Boolean getBackupRetentionEnabled() {
        return this.backupRetentionEnabled;
    }

    public RelationalDatabase withBackupRetentionEnabled(Boolean backupRetentionEnabled) {
        this.setBackupRetentionEnabled(backupRetentionEnabled);
        return this;
    }

    public Boolean isBackupRetentionEnabled() {
        return this.backupRetentionEnabled;
    }

    public void setPendingModifiedValues(PendingModifiedRelationalDatabaseValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public PendingModifiedRelationalDatabaseValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public RelationalDatabase withPendingModifiedValues(PendingModifiedRelationalDatabaseValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public RelationalDatabase withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public RelationalDatabase withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public RelationalDatabase withLatestRestorableTime(Date latestRestorableTime) {
        this.setLatestRestorableTime(latestRestorableTime);
        return this;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public RelationalDatabase withMasterUsername(String masterUsername) {
        this.setMasterUsername(masterUsername);
        return this;
    }

    public void setParameterApplyStatus(String parameterApplyStatus) {
        this.parameterApplyStatus = parameterApplyStatus;
    }

    public String getParameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public RelationalDatabase withParameterApplyStatus(String parameterApplyStatus) {
        this.setParameterApplyStatus(parameterApplyStatus);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public RelationalDatabase withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public RelationalDatabase withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public RelationalDatabase withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setMasterEndpoint(RelationalDatabaseEndpoint masterEndpoint) {
        this.masterEndpoint = masterEndpoint;
    }

    public RelationalDatabaseEndpoint getMasterEndpoint() {
        return this.masterEndpoint;
    }

    public RelationalDatabase withMasterEndpoint(RelationalDatabaseEndpoint masterEndpoint) {
        this.setMasterEndpoint(masterEndpoint);
        return this;
    }

    public List<PendingMaintenanceAction> getPendingMaintenanceActions() {
        return this.pendingMaintenanceActions;
    }

    public void setPendingMaintenanceActions(Collection<PendingMaintenanceAction> pendingMaintenanceActions) {
        if (pendingMaintenanceActions == null) {
            this.pendingMaintenanceActions = null;
            return;
        }
        this.pendingMaintenanceActions = new ArrayList<PendingMaintenanceAction>(pendingMaintenanceActions);
    }

    public RelationalDatabase withPendingMaintenanceActions(PendingMaintenanceAction ... pendingMaintenanceActions) {
        if (this.pendingMaintenanceActions == null) {
            this.setPendingMaintenanceActions(new ArrayList<PendingMaintenanceAction>(pendingMaintenanceActions.length));
        }
        for (PendingMaintenanceAction ele : pendingMaintenanceActions) {
            this.pendingMaintenanceActions.add(ele);
        }
        return this;
    }

    public RelationalDatabase withPendingMaintenanceActions(Collection<PendingMaintenanceAction> pendingMaintenanceActions) {
        this.setPendingMaintenanceActions(pendingMaintenanceActions);
        return this;
    }

    public void setCaCertificateIdentifier(String caCertificateIdentifier) {
        this.caCertificateIdentifier = caCertificateIdentifier;
    }

    public String getCaCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public RelationalDatabase withCaCertificateIdentifier(String caCertificateIdentifier) {
        this.setCaCertificateIdentifier(caCertificateIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getRelationalDatabaseBlueprintId() != null) {
            sb.append("RelationalDatabaseBlueprintId: ").append(this.getRelationalDatabaseBlueprintId()).append(",");
        }
        if (this.getRelationalDatabaseBundleId() != null) {
            sb.append("RelationalDatabaseBundleId: ").append(this.getRelationalDatabaseBundleId()).append(",");
        }
        if (this.getMasterDatabaseName() != null) {
            sb.append("MasterDatabaseName: ").append(this.getMasterDatabaseName()).append(",");
        }
        if (this.getHardware() != null) {
            sb.append("Hardware: ").append(this.getHardware()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getSecondaryAvailabilityZone() != null) {
            sb.append("SecondaryAvailabilityZone: ").append(this.getSecondaryAvailabilityZone()).append(",");
        }
        if (this.getBackupRetentionEnabled() != null) {
            sb.append("BackupRetentionEnabled: ").append(this.getBackupRetentionEnabled()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.getLatestRestorableTime()).append(",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: ").append(this.getMasterUsername()).append(",");
        }
        if (this.getParameterApplyStatus() != null) {
            sb.append("ParameterApplyStatus: ").append(this.getParameterApplyStatus()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getMasterEndpoint() != null) {
            sb.append("MasterEndpoint: ").append(this.getMasterEndpoint()).append(",");
        }
        if (this.getPendingMaintenanceActions() != null) {
            sb.append("PendingMaintenanceActions: ").append(this.getPendingMaintenanceActions()).append(",");
        }
        if (this.getCaCertificateIdentifier() != null) {
            sb.append("CaCertificateIdentifier: ").append(this.getCaCertificateIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabase)) {
            return false;
        }
        RelationalDatabase other = (RelationalDatabase)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getRelationalDatabaseBlueprintId() == null ^ this.getRelationalDatabaseBlueprintId() == null) {
            return false;
        }
        if (other.getRelationalDatabaseBlueprintId() != null && !other.getRelationalDatabaseBlueprintId().equals(this.getRelationalDatabaseBlueprintId())) {
            return false;
        }
        if (other.getRelationalDatabaseBundleId() == null ^ this.getRelationalDatabaseBundleId() == null) {
            return false;
        }
        if (other.getRelationalDatabaseBundleId() != null && !other.getRelationalDatabaseBundleId().equals(this.getRelationalDatabaseBundleId())) {
            return false;
        }
        if (other.getMasterDatabaseName() == null ^ this.getMasterDatabaseName() == null) {
            return false;
        }
        if (other.getMasterDatabaseName() != null && !other.getMasterDatabaseName().equals(this.getMasterDatabaseName())) {
            return false;
        }
        if (other.getHardware() == null ^ this.getHardware() == null) {
            return false;
        }
        if (other.getHardware() != null && !other.getHardware().equals(this.getHardware())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() == null ^ this.getSecondaryAvailabilityZone() == null) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() != null && !other.getSecondaryAvailabilityZone().equals(this.getSecondaryAvailabilityZone())) {
            return false;
        }
        if (other.getBackupRetentionEnabled() == null ^ this.getBackupRetentionEnabled() == null) {
            return false;
        }
        if (other.getBackupRetentionEnabled() != null && !other.getBackupRetentionEnabled().equals(this.getBackupRetentionEnabled())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getParameterApplyStatus() == null ^ this.getParameterApplyStatus() == null) {
            return false;
        }
        if (other.getParameterApplyStatus() != null && !other.getParameterApplyStatus().equals(this.getParameterApplyStatus())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getMasterEndpoint() == null ^ this.getMasterEndpoint() == null) {
            return false;
        }
        if (other.getMasterEndpoint() != null && !other.getMasterEndpoint().equals(this.getMasterEndpoint())) {
            return false;
        }
        if (other.getPendingMaintenanceActions() == null ^ this.getPendingMaintenanceActions() == null) {
            return false;
        }
        if (other.getPendingMaintenanceActions() != null && !other.getPendingMaintenanceActions().equals(this.getPendingMaintenanceActions())) {
            return false;
        }
        if (other.getCaCertificateIdentifier() == null ^ this.getCaCertificateIdentifier() == null) {
            return false;
        }
        return other.getCaCertificateIdentifier() == null || other.getCaCertificateIdentifier().equals(this.getCaCertificateIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getRelationalDatabaseBlueprintId() == null ? 0 : this.getRelationalDatabaseBlueprintId().hashCode());
        hashCode = 31 * hashCode + (this.getRelationalDatabaseBundleId() == null ? 0 : this.getRelationalDatabaseBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getMasterDatabaseName() == null ? 0 : this.getMasterDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getHardware() == null ? 0 : this.getHardware().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryAvailabilityZone() == null ? 0 : this.getSecondaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionEnabled() == null ? 0 : this.getBackupRetentionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getParameterApplyStatus() == null ? 0 : this.getParameterApplyStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getMasterEndpoint() == null ? 0 : this.getMasterEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getPendingMaintenanceActions() == null ? 0 : this.getPendingMaintenanceActions().hashCode());
        hashCode = 31 * hashCode + (this.getCaCertificateIdentifier() == null ? 0 : this.getCaCertificateIdentifier().hashCode());
        return hashCode;
    }

    public RelationalDatabase clone() {
        try {
            return (RelationalDatabase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RelationalDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

