/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanagerlinuxsubscriptions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration;
import com.amazonaws.services.licensemanagerlinuxsubscriptions.model.transform.LinuxSubscriptionsDiscoverySettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinuxSubscriptionsDiscoverySettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String organizationIntegration;
    private List<String> sourceRegions;

    public void setOrganizationIntegration(String organizationIntegration) {
        this.organizationIntegration = organizationIntegration;
    }

    public String getOrganizationIntegration() {
        return this.organizationIntegration;
    }

    public LinuxSubscriptionsDiscoverySettings withOrganizationIntegration(String organizationIntegration) {
        this.setOrganizationIntegration(organizationIntegration);
        return this;
    }

    public LinuxSubscriptionsDiscoverySettings withOrganizationIntegration(OrganizationIntegration organizationIntegration) {
        this.organizationIntegration = organizationIntegration.toString();
        return this;
    }

    public List<String> getSourceRegions() {
        return this.sourceRegions;
    }

    public void setSourceRegions(Collection<String> sourceRegions) {
        if (sourceRegions == null) {
            this.sourceRegions = null;
            return;
        }
        this.sourceRegions = new ArrayList<String>(sourceRegions);
    }

    public LinuxSubscriptionsDiscoverySettings withSourceRegions(String ... sourceRegions) {
        if (this.sourceRegions == null) {
            this.setSourceRegions(new ArrayList<String>(sourceRegions.length));
        }
        for (String ele : sourceRegions) {
            this.sourceRegions.add(ele);
        }
        return this;
    }

    public LinuxSubscriptionsDiscoverySettings withSourceRegions(Collection<String> sourceRegions) {
        this.setSourceRegions(sourceRegions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOrganizationIntegration() != null) {
            sb.append("OrganizationIntegration: ").append(this.getOrganizationIntegration()).append(",");
        }
        if (this.getSourceRegions() != null) {
            sb.append("SourceRegions: ").append(this.getSourceRegions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinuxSubscriptionsDiscoverySettings)) {
            return false;
        }
        LinuxSubscriptionsDiscoverySettings other = (LinuxSubscriptionsDiscoverySettings)obj;
        if (other.getOrganizationIntegration() == null ^ this.getOrganizationIntegration() == null) {
            return false;
        }
        if (other.getOrganizationIntegration() != null && !other.getOrganizationIntegration().equals(this.getOrganizationIntegration())) {
            return false;
        }
        if (other.getSourceRegions() == null ^ this.getSourceRegions() == null) {
            return false;
        }
        return other.getSourceRegions() == null || other.getSourceRegions().equals(this.getSourceRegions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOrganizationIntegration() == null ? 0 : this.getOrganizationIntegration().hashCode());
        hashCode = 31 * hashCode + (this.getSourceRegions() == null ? 0 : this.getSourceRegions().hashCode());
        return hashCode;
    }

    public LinuxSubscriptionsDiscoverySettings clone() {
        try {
            return (LinuxSubscriptionsDiscoverySettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinuxSubscriptionsDiscoverySettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

