/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.EntitlementUnit;
import com.amazonaws.services.licensemanager.model.transform.EntitlementMarshaller;
import java.io.Serializable;

public class Entitlement
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String value;
    private Long maxCount;
    private Boolean overage;
    private String unit;
    private Boolean allowCheckIn;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Entitlement withName(String name) {
        this.setName(name);
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Entitlement withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setMaxCount(Long maxCount) {
        this.maxCount = maxCount;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public Entitlement withMaxCount(Long maxCount) {
        this.setMaxCount(maxCount);
        return this;
    }

    public void setOverage(Boolean overage) {
        this.overage = overage;
    }

    public Boolean getOverage() {
        return this.overage;
    }

    public Entitlement withOverage(Boolean overage) {
        this.setOverage(overage);
        return this;
    }

    public Boolean isOverage() {
        return this.overage;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public Entitlement withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public Entitlement withUnit(EntitlementUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public void setAllowCheckIn(Boolean allowCheckIn) {
        this.allowCheckIn = allowCheckIn;
    }

    public Boolean getAllowCheckIn() {
        return this.allowCheckIn;
    }

    public Entitlement withAllowCheckIn(Boolean allowCheckIn) {
        this.setAllowCheckIn(allowCheckIn);
        return this;
    }

    public Boolean isAllowCheckIn() {
        return this.allowCheckIn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getMaxCount() != null) {
            sb.append("MaxCount: ").append(this.getMaxCount()).append(",");
        }
        if (this.getOverage() != null) {
            sb.append("Overage: ").append(this.getOverage()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit()).append(",");
        }
        if (this.getAllowCheckIn() != null) {
            sb.append("AllowCheckIn: ").append(this.getAllowCheckIn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getMaxCount() == null ^ this.getMaxCount() == null) {
            return false;
        }
        if (other.getMaxCount() != null && !other.getMaxCount().equals(this.getMaxCount())) {
            return false;
        }
        if (other.getOverage() == null ^ this.getOverage() == null) {
            return false;
        }
        if (other.getOverage() != null && !other.getOverage().equals(this.getOverage())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getAllowCheckIn() == null ^ this.getAllowCheckIn() == null) {
            return false;
        }
        return other.getAllowCheckIn() == null || other.getAllowCheckIn().equals(this.getAllowCheckIn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCount() == null ? 0 : this.getMaxCount().hashCode());
        hashCode = 31 * hashCode + (this.getOverage() == null ? 0 : this.getOverage().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getAllowCheckIn() == null ? 0 : this.getAllowCheckIn().hashCode());
        return hashCode;
    }

    public Entitlement clone() {
        try {
            return (Entitlement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntitlementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

