/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.licensemanager.AWSLicenseManagerAsync;
import com.amazonaws.services.licensemanager.AWSLicenseManagerAsyncClientBuilder;
import com.amazonaws.services.licensemanager.AWSLicenseManagerClient;
import com.amazonaws.services.licensemanager.model.AcceptGrantRequest;
import com.amazonaws.services.licensemanager.model.AcceptGrantResult;
import com.amazonaws.services.licensemanager.model.CheckInLicenseRequest;
import com.amazonaws.services.licensemanager.model.CheckInLicenseResult;
import com.amazonaws.services.licensemanager.model.CheckoutBorrowLicenseRequest;
import com.amazonaws.services.licensemanager.model.CheckoutBorrowLicenseResult;
import com.amazonaws.services.licensemanager.model.CheckoutLicenseRequest;
import com.amazonaws.services.licensemanager.model.CheckoutLicenseResult;
import com.amazonaws.services.licensemanager.model.CreateGrantRequest;
import com.amazonaws.services.licensemanager.model.CreateGrantResult;
import com.amazonaws.services.licensemanager.model.CreateGrantVersionRequest;
import com.amazonaws.services.licensemanager.model.CreateGrantVersionResult;
import com.amazonaws.services.licensemanager.model.CreateLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseConversionTaskForResourceResult;
import com.amazonaws.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseManagerReportGeneratorResult;
import com.amazonaws.services.licensemanager.model.CreateLicenseRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseResult;
import com.amazonaws.services.licensemanager.model.CreateLicenseVersionRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseVersionResult;
import com.amazonaws.services.licensemanager.model.CreateTokenRequest;
import com.amazonaws.services.licensemanager.model.CreateTokenResult;
import com.amazonaws.services.licensemanager.model.DeleteGrantRequest;
import com.amazonaws.services.licensemanager.model.DeleteGrantResult;
import com.amazonaws.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.DeleteLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest;
import com.amazonaws.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResult;
import com.amazonaws.services.licensemanager.model.DeleteLicenseRequest;
import com.amazonaws.services.licensemanager.model.DeleteLicenseResult;
import com.amazonaws.services.licensemanager.model.DeleteTokenRequest;
import com.amazonaws.services.licensemanager.model.DeleteTokenResult;
import com.amazonaws.services.licensemanager.model.ExtendLicenseConsumptionRequest;
import com.amazonaws.services.licensemanager.model.ExtendLicenseConsumptionResult;
import com.amazonaws.services.licensemanager.model.GetAccessTokenRequest;
import com.amazonaws.services.licensemanager.model.GetAccessTokenResult;
import com.amazonaws.services.licensemanager.model.GetGrantRequest;
import com.amazonaws.services.licensemanager.model.GetGrantResult;
import com.amazonaws.services.licensemanager.model.GetLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.GetLicenseConversionTaskRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseConversionTaskResult;
import com.amazonaws.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseManagerReportGeneratorResult;
import com.amazonaws.services.licensemanager.model.GetLicenseRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseResult;
import com.amazonaws.services.licensemanager.model.GetLicenseUsageRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseUsageResult;
import com.amazonaws.services.licensemanager.model.GetServiceSettingsRequest;
import com.amazonaws.services.licensemanager.model.GetServiceSettingsResult;
import com.amazonaws.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.ListAssociationsForLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.ListDistributedGrantsRequest;
import com.amazonaws.services.licensemanager.model.ListDistributedGrantsResult;
import com.amazonaws.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest;
import com.amazonaws.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResult;
import com.amazonaws.services.licensemanager.model.ListLicenseConfigurationsRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseConfigurationsResult;
import com.amazonaws.services.licensemanager.model.ListLicenseConversionTasksRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseConversionTasksResult;
import com.amazonaws.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseManagerReportGeneratorsResult;
import com.amazonaws.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseSpecificationsForResourceResult;
import com.amazonaws.services.licensemanager.model.ListLicenseVersionsRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseVersionsResult;
import com.amazonaws.services.licensemanager.model.ListLicensesRequest;
import com.amazonaws.services.licensemanager.model.ListLicensesResult;
import com.amazonaws.services.licensemanager.model.ListReceivedGrantsRequest;
import com.amazonaws.services.licensemanager.model.ListReceivedGrantsResult;
import com.amazonaws.services.licensemanager.model.ListReceivedLicensesRequest;
import com.amazonaws.services.licensemanager.model.ListReceivedLicensesResult;
import com.amazonaws.services.licensemanager.model.ListResourceInventoryRequest;
import com.amazonaws.services.licensemanager.model.ListResourceInventoryResult;
import com.amazonaws.services.licensemanager.model.ListTagsForResourceRequest;
import com.amazonaws.services.licensemanager.model.ListTagsForResourceResult;
import com.amazonaws.services.licensemanager.model.ListTokensRequest;
import com.amazonaws.services.licensemanager.model.ListTokensResult;
import com.amazonaws.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.ListUsageForLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.RejectGrantRequest;
import com.amazonaws.services.licensemanager.model.RejectGrantResult;
import com.amazonaws.services.licensemanager.model.TagResourceRequest;
import com.amazonaws.services.licensemanager.model.TagResourceResult;
import com.amazonaws.services.licensemanager.model.UntagResourceRequest;
import com.amazonaws.services.licensemanager.model.UntagResourceResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResult;
import com.amazonaws.services.licensemanager.model.UpdateServiceSettingsRequest;
import com.amazonaws.services.licensemanager.model.UpdateServiceSettingsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLicenseManagerAsyncClient
extends AWSLicenseManagerClient
implements AWSLicenseManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSLicenseManagerAsyncClientBuilder asyncBuilder() {
        return AWSLicenseManagerAsyncClientBuilder.standard();
    }

    AWSLicenseManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSLicenseManagerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptGrantResult> acceptGrantAsync(AcceptGrantRequest request) {
        return this.acceptGrantAsync(request, null);
    }

    @Override
    public Future<AcceptGrantResult> acceptGrantAsync(AcceptGrantRequest request, final AsyncHandler<AcceptGrantRequest, AcceptGrantResult> asyncHandler) {
        final AcceptGrantRequest finalRequest = (AcceptGrantRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptGrantResult>(){

            @Override
            public AcceptGrantResult call() throws Exception {
                AcceptGrantResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeAcceptGrant(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CheckInLicenseResult> checkInLicenseAsync(CheckInLicenseRequest request) {
        return this.checkInLicenseAsync(request, null);
    }

    @Override
    public Future<CheckInLicenseResult> checkInLicenseAsync(CheckInLicenseRequest request, final AsyncHandler<CheckInLicenseRequest, CheckInLicenseResult> asyncHandler) {
        final CheckInLicenseRequest finalRequest = (CheckInLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CheckInLicenseResult>(){

            @Override
            public CheckInLicenseResult call() throws Exception {
                CheckInLicenseResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCheckInLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CheckoutBorrowLicenseResult> checkoutBorrowLicenseAsync(CheckoutBorrowLicenseRequest request) {
        return this.checkoutBorrowLicenseAsync(request, null);
    }

    @Override
    public Future<CheckoutBorrowLicenseResult> checkoutBorrowLicenseAsync(CheckoutBorrowLicenseRequest request, final AsyncHandler<CheckoutBorrowLicenseRequest, CheckoutBorrowLicenseResult> asyncHandler) {
        final CheckoutBorrowLicenseRequest finalRequest = (CheckoutBorrowLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CheckoutBorrowLicenseResult>(){

            @Override
            public CheckoutBorrowLicenseResult call() throws Exception {
                CheckoutBorrowLicenseResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCheckoutBorrowLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CheckoutLicenseResult> checkoutLicenseAsync(CheckoutLicenseRequest request) {
        return this.checkoutLicenseAsync(request, null);
    }

    @Override
    public Future<CheckoutLicenseResult> checkoutLicenseAsync(CheckoutLicenseRequest request, final AsyncHandler<CheckoutLicenseRequest, CheckoutLicenseResult> asyncHandler) {
        final CheckoutLicenseRequest finalRequest = (CheckoutLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CheckoutLicenseResult>(){

            @Override
            public CheckoutLicenseResult call() throws Exception {
                CheckoutLicenseResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCheckoutLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(CreateGrantRequest request) {
        return this.createGrantAsync(request, null);
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(CreateGrantRequest request, final AsyncHandler<CreateGrantRequest, CreateGrantResult> asyncHandler) {
        final CreateGrantRequest finalRequest = (CreateGrantRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGrantResult>(){

            @Override
            public CreateGrantResult call() throws Exception {
                CreateGrantResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateGrant(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGrantVersionResult> createGrantVersionAsync(CreateGrantVersionRequest request) {
        return this.createGrantVersionAsync(request, null);
    }

    @Override
    public Future<CreateGrantVersionResult> createGrantVersionAsync(CreateGrantVersionRequest request, final AsyncHandler<CreateGrantVersionRequest, CreateGrantVersionResult> asyncHandler) {
        final CreateGrantVersionRequest finalRequest = (CreateGrantVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGrantVersionResult>(){

            @Override
            public CreateGrantVersionResult call() throws Exception {
                CreateGrantVersionResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateGrantVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLicenseResult> createLicenseAsync(CreateLicenseRequest request) {
        return this.createLicenseAsync(request, null);
    }

    @Override
    public Future<CreateLicenseResult> createLicenseAsync(CreateLicenseRequest request, final AsyncHandler<CreateLicenseRequest, CreateLicenseResult> asyncHandler) {
        final CreateLicenseRequest finalRequest = (CreateLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLicenseResult>(){

            @Override
            public CreateLicenseResult call() throws Exception {
                CreateLicenseResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLicenseConfigurationResult> createLicenseConfigurationAsync(CreateLicenseConfigurationRequest request) {
        return this.createLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateLicenseConfigurationResult> createLicenseConfigurationAsync(CreateLicenseConfigurationRequest request, final AsyncHandler<CreateLicenseConfigurationRequest, CreateLicenseConfigurationResult> asyncHandler) {
        final CreateLicenseConfigurationRequest finalRequest = (CreateLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLicenseConfigurationResult>(){

            @Override
            public CreateLicenseConfigurationResult call() throws Exception {
                CreateLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLicenseConversionTaskForResourceResult> createLicenseConversionTaskForResourceAsync(CreateLicenseConversionTaskForResourceRequest request) {
        return this.createLicenseConversionTaskForResourceAsync(request, null);
    }

    @Override
    public Future<CreateLicenseConversionTaskForResourceResult> createLicenseConversionTaskForResourceAsync(CreateLicenseConversionTaskForResourceRequest request, final AsyncHandler<CreateLicenseConversionTaskForResourceRequest, CreateLicenseConversionTaskForResourceResult> asyncHandler) {
        final CreateLicenseConversionTaskForResourceRequest finalRequest = (CreateLicenseConversionTaskForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLicenseConversionTaskForResourceResult>(){

            @Override
            public CreateLicenseConversionTaskForResourceResult call() throws Exception {
                CreateLicenseConversionTaskForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateLicenseConversionTaskForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLicenseManagerReportGeneratorResult> createLicenseManagerReportGeneratorAsync(CreateLicenseManagerReportGeneratorRequest request) {
        return this.createLicenseManagerReportGeneratorAsync(request, null);
    }

    @Override
    public Future<CreateLicenseManagerReportGeneratorResult> createLicenseManagerReportGeneratorAsync(CreateLicenseManagerReportGeneratorRequest request, final AsyncHandler<CreateLicenseManagerReportGeneratorRequest, CreateLicenseManagerReportGeneratorResult> asyncHandler) {
        final CreateLicenseManagerReportGeneratorRequest finalRequest = (CreateLicenseManagerReportGeneratorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLicenseManagerReportGeneratorResult>(){

            @Override
            public CreateLicenseManagerReportGeneratorResult call() throws Exception {
                CreateLicenseManagerReportGeneratorResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateLicenseManagerReportGenerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLicenseVersionResult> createLicenseVersionAsync(CreateLicenseVersionRequest request) {
        return this.createLicenseVersionAsync(request, null);
    }

    @Override
    public Future<CreateLicenseVersionResult> createLicenseVersionAsync(CreateLicenseVersionRequest request, final AsyncHandler<CreateLicenseVersionRequest, CreateLicenseVersionResult> asyncHandler) {
        final CreateLicenseVersionRequest finalRequest = (CreateLicenseVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLicenseVersionResult>(){

            @Override
            public CreateLicenseVersionResult call() throws Exception {
                CreateLicenseVersionResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateLicenseVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request) {
        return this.createTokenAsync(request, null);
    }

    @Override
    public Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request, final AsyncHandler<CreateTokenRequest, CreateTokenResult> asyncHandler) {
        final CreateTokenRequest finalRequest = (CreateTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTokenResult>(){

            @Override
            public CreateTokenResult call() throws Exception {
                CreateTokenResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeCreateToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGrantResult> deleteGrantAsync(DeleteGrantRequest request) {
        return this.deleteGrantAsync(request, null);
    }

    @Override
    public Future<DeleteGrantResult> deleteGrantAsync(DeleteGrantRequest request, final AsyncHandler<DeleteGrantRequest, DeleteGrantResult> asyncHandler) {
        final DeleteGrantRequest finalRequest = (DeleteGrantRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGrantResult>(){

            @Override
            public DeleteGrantResult call() throws Exception {
                DeleteGrantResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeDeleteGrant(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLicenseResult> deleteLicenseAsync(DeleteLicenseRequest request) {
        return this.deleteLicenseAsync(request, null);
    }

    @Override
    public Future<DeleteLicenseResult> deleteLicenseAsync(DeleteLicenseRequest request, final AsyncHandler<DeleteLicenseRequest, DeleteLicenseResult> asyncHandler) {
        final DeleteLicenseRequest finalRequest = (DeleteLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLicenseResult>(){

            @Override
            public DeleteLicenseResult call() throws Exception {
                DeleteLicenseResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeDeleteLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLicenseConfigurationResult> deleteLicenseConfigurationAsync(DeleteLicenseConfigurationRequest request) {
        return this.deleteLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteLicenseConfigurationResult> deleteLicenseConfigurationAsync(DeleteLicenseConfigurationRequest request, final AsyncHandler<DeleteLicenseConfigurationRequest, DeleteLicenseConfigurationResult> asyncHandler) {
        final DeleteLicenseConfigurationRequest finalRequest = (DeleteLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLicenseConfigurationResult>(){

            @Override
            public DeleteLicenseConfigurationResult call() throws Exception {
                DeleteLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeDeleteLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLicenseManagerReportGeneratorResult> deleteLicenseManagerReportGeneratorAsync(DeleteLicenseManagerReportGeneratorRequest request) {
        return this.deleteLicenseManagerReportGeneratorAsync(request, null);
    }

    @Override
    public Future<DeleteLicenseManagerReportGeneratorResult> deleteLicenseManagerReportGeneratorAsync(DeleteLicenseManagerReportGeneratorRequest request, final AsyncHandler<DeleteLicenseManagerReportGeneratorRequest, DeleteLicenseManagerReportGeneratorResult> asyncHandler) {
        final DeleteLicenseManagerReportGeneratorRequest finalRequest = (DeleteLicenseManagerReportGeneratorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLicenseManagerReportGeneratorResult>(){

            @Override
            public DeleteLicenseManagerReportGeneratorResult call() throws Exception {
                DeleteLicenseManagerReportGeneratorResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeDeleteLicenseManagerReportGenerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTokenResult> deleteTokenAsync(DeleteTokenRequest request) {
        return this.deleteTokenAsync(request, null);
    }

    @Override
    public Future<DeleteTokenResult> deleteTokenAsync(DeleteTokenRequest request, final AsyncHandler<DeleteTokenRequest, DeleteTokenResult> asyncHandler) {
        final DeleteTokenRequest finalRequest = (DeleteTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTokenResult>(){

            @Override
            public DeleteTokenResult call() throws Exception {
                DeleteTokenResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeDeleteToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExtendLicenseConsumptionResult> extendLicenseConsumptionAsync(ExtendLicenseConsumptionRequest request) {
        return this.extendLicenseConsumptionAsync(request, null);
    }

    @Override
    public Future<ExtendLicenseConsumptionResult> extendLicenseConsumptionAsync(ExtendLicenseConsumptionRequest request, final AsyncHandler<ExtendLicenseConsumptionRequest, ExtendLicenseConsumptionResult> asyncHandler) {
        final ExtendLicenseConsumptionRequest finalRequest = (ExtendLicenseConsumptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExtendLicenseConsumptionResult>(){

            @Override
            public ExtendLicenseConsumptionResult call() throws Exception {
                ExtendLicenseConsumptionResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeExtendLicenseConsumption(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessTokenResult> getAccessTokenAsync(GetAccessTokenRequest request) {
        return this.getAccessTokenAsync(request, null);
    }

    @Override
    public Future<GetAccessTokenResult> getAccessTokenAsync(GetAccessTokenRequest request, final AsyncHandler<GetAccessTokenRequest, GetAccessTokenResult> asyncHandler) {
        final GetAccessTokenRequest finalRequest = (GetAccessTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessTokenResult>(){

            @Override
            public GetAccessTokenResult call() throws Exception {
                GetAccessTokenResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetAccessToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGrantResult> getGrantAsync(GetGrantRequest request) {
        return this.getGrantAsync(request, null);
    }

    @Override
    public Future<GetGrantResult> getGrantAsync(GetGrantRequest request, final AsyncHandler<GetGrantRequest, GetGrantResult> asyncHandler) {
        final GetGrantRequest finalRequest = (GetGrantRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGrantResult>(){

            @Override
            public GetGrantResult call() throws Exception {
                GetGrantResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetGrant(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLicenseResult> getLicenseAsync(GetLicenseRequest request) {
        return this.getLicenseAsync(request, null);
    }

    @Override
    public Future<GetLicenseResult> getLicenseAsync(GetLicenseRequest request, final AsyncHandler<GetLicenseRequest, GetLicenseResult> asyncHandler) {
        final GetLicenseRequest finalRequest = (GetLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLicenseResult>(){

            @Override
            public GetLicenseResult call() throws Exception {
                GetLicenseResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLicenseConfigurationResult> getLicenseConfigurationAsync(GetLicenseConfigurationRequest request) {
        return this.getLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<GetLicenseConfigurationResult> getLicenseConfigurationAsync(GetLicenseConfigurationRequest request, final AsyncHandler<GetLicenseConfigurationRequest, GetLicenseConfigurationResult> asyncHandler) {
        final GetLicenseConfigurationRequest finalRequest = (GetLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLicenseConfigurationResult>(){

            @Override
            public GetLicenseConfigurationResult call() throws Exception {
                GetLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLicenseConversionTaskResult> getLicenseConversionTaskAsync(GetLicenseConversionTaskRequest request) {
        return this.getLicenseConversionTaskAsync(request, null);
    }

    @Override
    public Future<GetLicenseConversionTaskResult> getLicenseConversionTaskAsync(GetLicenseConversionTaskRequest request, final AsyncHandler<GetLicenseConversionTaskRequest, GetLicenseConversionTaskResult> asyncHandler) {
        final GetLicenseConversionTaskRequest finalRequest = (GetLicenseConversionTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLicenseConversionTaskResult>(){

            @Override
            public GetLicenseConversionTaskResult call() throws Exception {
                GetLicenseConversionTaskResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetLicenseConversionTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLicenseManagerReportGeneratorResult> getLicenseManagerReportGeneratorAsync(GetLicenseManagerReportGeneratorRequest request) {
        return this.getLicenseManagerReportGeneratorAsync(request, null);
    }

    @Override
    public Future<GetLicenseManagerReportGeneratorResult> getLicenseManagerReportGeneratorAsync(GetLicenseManagerReportGeneratorRequest request, final AsyncHandler<GetLicenseManagerReportGeneratorRequest, GetLicenseManagerReportGeneratorResult> asyncHandler) {
        final GetLicenseManagerReportGeneratorRequest finalRequest = (GetLicenseManagerReportGeneratorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLicenseManagerReportGeneratorResult>(){

            @Override
            public GetLicenseManagerReportGeneratorResult call() throws Exception {
                GetLicenseManagerReportGeneratorResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetLicenseManagerReportGenerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLicenseUsageResult> getLicenseUsageAsync(GetLicenseUsageRequest request) {
        return this.getLicenseUsageAsync(request, null);
    }

    @Override
    public Future<GetLicenseUsageResult> getLicenseUsageAsync(GetLicenseUsageRequest request, final AsyncHandler<GetLicenseUsageRequest, GetLicenseUsageResult> asyncHandler) {
        final GetLicenseUsageRequest finalRequest = (GetLicenseUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLicenseUsageResult>(){

            @Override
            public GetLicenseUsageResult call() throws Exception {
                GetLicenseUsageResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetLicenseUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServiceSettingsResult> getServiceSettingsAsync(GetServiceSettingsRequest request) {
        return this.getServiceSettingsAsync(request, null);
    }

    @Override
    public Future<GetServiceSettingsResult> getServiceSettingsAsync(GetServiceSettingsRequest request, final AsyncHandler<GetServiceSettingsRequest, GetServiceSettingsResult> asyncHandler) {
        final GetServiceSettingsRequest finalRequest = (GetServiceSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetServiceSettingsResult>(){

            @Override
            public GetServiceSettingsResult call() throws Exception {
                GetServiceSettingsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeGetServiceSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociationsForLicenseConfigurationResult> listAssociationsForLicenseConfigurationAsync(ListAssociationsForLicenseConfigurationRequest request) {
        return this.listAssociationsForLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<ListAssociationsForLicenseConfigurationResult> listAssociationsForLicenseConfigurationAsync(ListAssociationsForLicenseConfigurationRequest request, final AsyncHandler<ListAssociationsForLicenseConfigurationRequest, ListAssociationsForLicenseConfigurationResult> asyncHandler) {
        final ListAssociationsForLicenseConfigurationRequest finalRequest = (ListAssociationsForLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociationsForLicenseConfigurationResult>(){

            @Override
            public ListAssociationsForLicenseConfigurationResult call() throws Exception {
                ListAssociationsForLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListAssociationsForLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDistributedGrantsResult> listDistributedGrantsAsync(ListDistributedGrantsRequest request) {
        return this.listDistributedGrantsAsync(request, null);
    }

    @Override
    public Future<ListDistributedGrantsResult> listDistributedGrantsAsync(ListDistributedGrantsRequest request, final AsyncHandler<ListDistributedGrantsRequest, ListDistributedGrantsResult> asyncHandler) {
        final ListDistributedGrantsRequest finalRequest = (ListDistributedGrantsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDistributedGrantsResult>(){

            @Override
            public ListDistributedGrantsResult call() throws Exception {
                ListDistributedGrantsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListDistributedGrants(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFailuresForLicenseConfigurationOperationsResult> listFailuresForLicenseConfigurationOperationsAsync(ListFailuresForLicenseConfigurationOperationsRequest request) {
        return this.listFailuresForLicenseConfigurationOperationsAsync(request, null);
    }

    @Override
    public Future<ListFailuresForLicenseConfigurationOperationsResult> listFailuresForLicenseConfigurationOperationsAsync(ListFailuresForLicenseConfigurationOperationsRequest request, final AsyncHandler<ListFailuresForLicenseConfigurationOperationsRequest, ListFailuresForLicenseConfigurationOperationsResult> asyncHandler) {
        final ListFailuresForLicenseConfigurationOperationsRequest finalRequest = (ListFailuresForLicenseConfigurationOperationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFailuresForLicenseConfigurationOperationsResult>(){

            @Override
            public ListFailuresForLicenseConfigurationOperationsResult call() throws Exception {
                ListFailuresForLicenseConfigurationOperationsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListFailuresForLicenseConfigurationOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseConfigurationsResult> listLicenseConfigurationsAsync(ListLicenseConfigurationsRequest request) {
        return this.listLicenseConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListLicenseConfigurationsResult> listLicenseConfigurationsAsync(ListLicenseConfigurationsRequest request, final AsyncHandler<ListLicenseConfigurationsRequest, ListLicenseConfigurationsResult> asyncHandler) {
        final ListLicenseConfigurationsRequest finalRequest = (ListLicenseConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseConfigurationsResult>(){

            @Override
            public ListLicenseConfigurationsResult call() throws Exception {
                ListLicenseConfigurationsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseConversionTasksResult> listLicenseConversionTasksAsync(ListLicenseConversionTasksRequest request) {
        return this.listLicenseConversionTasksAsync(request, null);
    }

    @Override
    public Future<ListLicenseConversionTasksResult> listLicenseConversionTasksAsync(ListLicenseConversionTasksRequest request, final AsyncHandler<ListLicenseConversionTasksRequest, ListLicenseConversionTasksResult> asyncHandler) {
        final ListLicenseConversionTasksRequest finalRequest = (ListLicenseConversionTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseConversionTasksResult>(){

            @Override
            public ListLicenseConversionTasksResult call() throws Exception {
                ListLicenseConversionTasksResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseConversionTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseManagerReportGeneratorsResult> listLicenseManagerReportGeneratorsAsync(ListLicenseManagerReportGeneratorsRequest request) {
        return this.listLicenseManagerReportGeneratorsAsync(request, null);
    }

    @Override
    public Future<ListLicenseManagerReportGeneratorsResult> listLicenseManagerReportGeneratorsAsync(ListLicenseManagerReportGeneratorsRequest request, final AsyncHandler<ListLicenseManagerReportGeneratorsRequest, ListLicenseManagerReportGeneratorsResult> asyncHandler) {
        final ListLicenseManagerReportGeneratorsRequest finalRequest = (ListLicenseManagerReportGeneratorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseManagerReportGeneratorsResult>(){

            @Override
            public ListLicenseManagerReportGeneratorsResult call() throws Exception {
                ListLicenseManagerReportGeneratorsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseManagerReportGenerators(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseSpecificationsForResourceResult> listLicenseSpecificationsForResourceAsync(ListLicenseSpecificationsForResourceRequest request) {
        return this.listLicenseSpecificationsForResourceAsync(request, null);
    }

    @Override
    public Future<ListLicenseSpecificationsForResourceResult> listLicenseSpecificationsForResourceAsync(ListLicenseSpecificationsForResourceRequest request, final AsyncHandler<ListLicenseSpecificationsForResourceRequest, ListLicenseSpecificationsForResourceResult> asyncHandler) {
        final ListLicenseSpecificationsForResourceRequest finalRequest = (ListLicenseSpecificationsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseSpecificationsForResourceResult>(){

            @Override
            public ListLicenseSpecificationsForResourceResult call() throws Exception {
                ListLicenseSpecificationsForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseSpecificationsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicenseVersionsResult> listLicenseVersionsAsync(ListLicenseVersionsRequest request) {
        return this.listLicenseVersionsAsync(request, null);
    }

    @Override
    public Future<ListLicenseVersionsResult> listLicenseVersionsAsync(ListLicenseVersionsRequest request, final AsyncHandler<ListLicenseVersionsRequest, ListLicenseVersionsResult> asyncHandler) {
        final ListLicenseVersionsRequest finalRequest = (ListLicenseVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicenseVersionsResult>(){

            @Override
            public ListLicenseVersionsResult call() throws Exception {
                ListLicenseVersionsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenseVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLicensesResult> listLicensesAsync(ListLicensesRequest request) {
        return this.listLicensesAsync(request, null);
    }

    @Override
    public Future<ListLicensesResult> listLicensesAsync(ListLicensesRequest request, final AsyncHandler<ListLicensesRequest, ListLicensesResult> asyncHandler) {
        final ListLicensesRequest finalRequest = (ListLicensesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLicensesResult>(){

            @Override
            public ListLicensesResult call() throws Exception {
                ListLicensesResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListLicenses(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReceivedGrantsResult> listReceivedGrantsAsync(ListReceivedGrantsRequest request) {
        return this.listReceivedGrantsAsync(request, null);
    }

    @Override
    public Future<ListReceivedGrantsResult> listReceivedGrantsAsync(ListReceivedGrantsRequest request, final AsyncHandler<ListReceivedGrantsRequest, ListReceivedGrantsResult> asyncHandler) {
        final ListReceivedGrantsRequest finalRequest = (ListReceivedGrantsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReceivedGrantsResult>(){

            @Override
            public ListReceivedGrantsResult call() throws Exception {
                ListReceivedGrantsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListReceivedGrants(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReceivedLicensesResult> listReceivedLicensesAsync(ListReceivedLicensesRequest request) {
        return this.listReceivedLicensesAsync(request, null);
    }

    @Override
    public Future<ListReceivedLicensesResult> listReceivedLicensesAsync(ListReceivedLicensesRequest request, final AsyncHandler<ListReceivedLicensesRequest, ListReceivedLicensesResult> asyncHandler) {
        final ListReceivedLicensesRequest finalRequest = (ListReceivedLicensesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReceivedLicensesResult>(){

            @Override
            public ListReceivedLicensesResult call() throws Exception {
                ListReceivedLicensesResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListReceivedLicenses(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceInventoryResult> listResourceInventoryAsync(ListResourceInventoryRequest request) {
        return this.listResourceInventoryAsync(request, null);
    }

    @Override
    public Future<ListResourceInventoryResult> listResourceInventoryAsync(ListResourceInventoryRequest request, final AsyncHandler<ListResourceInventoryRequest, ListResourceInventoryResult> asyncHandler) {
        final ListResourceInventoryRequest finalRequest = (ListResourceInventoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourceInventoryResult>(){

            @Override
            public ListResourceInventoryResult call() throws Exception {
                ListResourceInventoryResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListResourceInventory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTokensResult> listTokensAsync(ListTokensRequest request) {
        return this.listTokensAsync(request, null);
    }

    @Override
    public Future<ListTokensResult> listTokensAsync(ListTokensRequest request, final AsyncHandler<ListTokensRequest, ListTokensResult> asyncHandler) {
        final ListTokensRequest finalRequest = (ListTokensRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTokensResult>(){

            @Override
            public ListTokensResult call() throws Exception {
                ListTokensResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListTokens(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsageForLicenseConfigurationResult> listUsageForLicenseConfigurationAsync(ListUsageForLicenseConfigurationRequest request) {
        return this.listUsageForLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<ListUsageForLicenseConfigurationResult> listUsageForLicenseConfigurationAsync(ListUsageForLicenseConfigurationRequest request, final AsyncHandler<ListUsageForLicenseConfigurationRequest, ListUsageForLicenseConfigurationResult> asyncHandler) {
        final ListUsageForLicenseConfigurationRequest finalRequest = (ListUsageForLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsageForLicenseConfigurationResult>(){

            @Override
            public ListUsageForLicenseConfigurationResult call() throws Exception {
                ListUsageForLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeListUsageForLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectGrantResult> rejectGrantAsync(RejectGrantRequest request) {
        return this.rejectGrantAsync(request, null);
    }

    @Override
    public Future<RejectGrantResult> rejectGrantAsync(RejectGrantRequest request, final AsyncHandler<RejectGrantRequest, RejectGrantResult> asyncHandler) {
        final RejectGrantRequest finalRequest = (RejectGrantRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectGrantResult>(){

            @Override
            public RejectGrantResult call() throws Exception {
                RejectGrantResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeRejectGrant(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLicenseConfigurationResult> updateLicenseConfigurationAsync(UpdateLicenseConfigurationRequest request) {
        return this.updateLicenseConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateLicenseConfigurationResult> updateLicenseConfigurationAsync(UpdateLicenseConfigurationRequest request, final AsyncHandler<UpdateLicenseConfigurationRequest, UpdateLicenseConfigurationResult> asyncHandler) {
        final UpdateLicenseConfigurationRequest finalRequest = (UpdateLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLicenseConfigurationResult>(){

            @Override
            public UpdateLicenseConfigurationResult call() throws Exception {
                UpdateLicenseConfigurationResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateLicenseConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLicenseManagerReportGeneratorResult> updateLicenseManagerReportGeneratorAsync(UpdateLicenseManagerReportGeneratorRequest request) {
        return this.updateLicenseManagerReportGeneratorAsync(request, null);
    }

    @Override
    public Future<UpdateLicenseManagerReportGeneratorResult> updateLicenseManagerReportGeneratorAsync(UpdateLicenseManagerReportGeneratorRequest request, final AsyncHandler<UpdateLicenseManagerReportGeneratorRequest, UpdateLicenseManagerReportGeneratorResult> asyncHandler) {
        final UpdateLicenseManagerReportGeneratorRequest finalRequest = (UpdateLicenseManagerReportGeneratorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLicenseManagerReportGeneratorResult>(){

            @Override
            public UpdateLicenseManagerReportGeneratorResult call() throws Exception {
                UpdateLicenseManagerReportGeneratorResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateLicenseManagerReportGenerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLicenseSpecificationsForResourceResult> updateLicenseSpecificationsForResourceAsync(UpdateLicenseSpecificationsForResourceRequest request) {
        return this.updateLicenseSpecificationsForResourceAsync(request, null);
    }

    @Override
    public Future<UpdateLicenseSpecificationsForResourceResult> updateLicenseSpecificationsForResourceAsync(UpdateLicenseSpecificationsForResourceRequest request, final AsyncHandler<UpdateLicenseSpecificationsForResourceRequest, UpdateLicenseSpecificationsForResourceResult> asyncHandler) {
        final UpdateLicenseSpecificationsForResourceRequest finalRequest = (UpdateLicenseSpecificationsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLicenseSpecificationsForResourceResult>(){

            @Override
            public UpdateLicenseSpecificationsForResourceResult call() throws Exception {
                UpdateLicenseSpecificationsForResourceResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateLicenseSpecificationsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceSettingsResult> updateServiceSettingsAsync(UpdateServiceSettingsRequest request) {
        return this.updateServiceSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateServiceSettingsResult> updateServiceSettingsAsync(UpdateServiceSettingsRequest request, final AsyncHandler<UpdateServiceSettingsRequest, UpdateServiceSettingsResult> asyncHandler) {
        final UpdateServiceSettingsRequest finalRequest = (UpdateServiceSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateServiceSettingsResult>(){

            @Override
            public UpdateServiceSettingsResult call() throws Exception {
                UpdateServiceSettingsResult result = null;
                try {
                    result = AWSLicenseManagerAsyncClient.this.executeUpdateServiceSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

