/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.Message;
import com.amazonaws.services.lexmodelsv2.model.transform.MessageGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private Message message;
    private List<Message> variations;

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public MessageGroup withMessage(Message message) {
        this.setMessage(message);
        return this;
    }

    public List<Message> getVariations() {
        return this.variations;
    }

    public void setVariations(Collection<Message> variations) {
        if (variations == null) {
            this.variations = null;
            return;
        }
        this.variations = new ArrayList<Message>(variations);
    }

    public MessageGroup withVariations(Message ... variations) {
        if (this.variations == null) {
            this.setVariations(new ArrayList<Message>(variations.length));
        }
        for (Message ele : variations) {
            this.variations.add(ele);
        }
        return this;
    }

    public MessageGroup withVariations(Collection<Message> variations) {
        this.setVariations(variations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getVariations() != null) {
            sb.append("Variations: ").append(this.getVariations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageGroup)) {
            return false;
        }
        MessageGroup other = (MessageGroup)obj;
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getVariations() == null ^ this.getVariations() == null) {
            return false;
        }
        return other.getVariations() == null || other.getVariations().equals(this.getVariations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVariations() == null ? 0 : this.getVariations().hashCode());
        return hashCode;
    }

    public MessageGroup clone() {
        try {
            return (MessageGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

