/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.TaggedTable;
import java.util.List;

@SdkInternalApi
public class TaggedTableMarshaller {
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<List> LFTAGONDATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LFTagOnDatabase").build();
    private static final MarshallingInfo<List> LFTAGSONTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LFTagsOnTable").build();
    private static final MarshallingInfo<List> LFTAGSONCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LFTagsOnColumns").build();
    private static final TaggedTableMarshaller instance = new TaggedTableMarshaller();

    public static TaggedTableMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaggedTable taggedTable, ProtocolMarshaller protocolMarshaller) {
        if (taggedTable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taggedTable.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall(taggedTable.getLFTagOnDatabase(), LFTAGONDATABASE_BINDING);
            protocolMarshaller.marshall(taggedTable.getLFTagsOnTable(), LFTAGSONTABLE_BINDING);
            protocolMarshaller.marshall(taggedTable.getLFTagsOnColumns(), LFTAGSONCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

