/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.LFTag;
import com.amazonaws.services.lakeformation.model.ResourceType;
import com.amazonaws.services.lakeformation.model.transform.LFTagPolicyResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LFTagPolicyResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String catalogId;
    private String resourceType;
    private List<LFTag> expression;

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public LFTagPolicyResource withCatalogId(String catalogId) {
        this.setCatalogId(catalogId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public LFTagPolicyResource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public LFTagPolicyResource withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<LFTag> getExpression() {
        return this.expression;
    }

    public void setExpression(Collection<LFTag> expression) {
        if (expression == null) {
            this.expression = null;
            return;
        }
        this.expression = new ArrayList<LFTag>(expression);
    }

    public LFTagPolicyResource withExpression(LFTag ... expression) {
        if (this.expression == null) {
            this.setExpression(new ArrayList<LFTag>(expression.length));
        }
        for (LFTag ele : expression) {
            this.expression.add(ele);
        }
        return this;
    }

    public LFTagPolicyResource withExpression(Collection<LFTag> expression) {
        this.setExpression(expression);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: ").append(this.getCatalogId()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFTagPolicyResource)) {
            return false;
        }
        LFTagPolicyResource other = (LFTagPolicyResource)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        return other.getExpression() == null || other.getExpression().equals(this.getExpression());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        return hashCode;
    }

    public LFTagPolicyResource clone() {
        try {
            return (LFTagPolicyResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LFTagPolicyResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

