/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kms.AWSKMSAsync;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.model.CancelKeyDeletionRequest;
import com.amazonaws.services.kms.model.CancelKeyDeletionResult;
import com.amazonaws.services.kms.model.CreateAliasRequest;
import com.amazonaws.services.kms.model.CreateAliasResult;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.CreateGrantResult;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.services.kms.model.CreateKeyResult;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.DeleteAliasRequest;
import com.amazonaws.services.kms.model.DeleteAliasResult;
import com.amazonaws.services.kms.model.DescribeKeyRequest;
import com.amazonaws.services.kms.model.DescribeKeyResult;
import com.amazonaws.services.kms.model.DisableKeyRequest;
import com.amazonaws.services.kms.model.DisableKeyResult;
import com.amazonaws.services.kms.model.DisableKeyRotationRequest;
import com.amazonaws.services.kms.model.DisableKeyRotationResult;
import com.amazonaws.services.kms.model.EnableKeyRequest;
import com.amazonaws.services.kms.model.EnableKeyResult;
import com.amazonaws.services.kms.model.EnableKeyRotationRequest;
import com.amazonaws.services.kms.model.EnableKeyRotationResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextResult;
import com.amazonaws.services.kms.model.GenerateRandomRequest;
import com.amazonaws.services.kms.model.GenerateRandomResult;
import com.amazonaws.services.kms.model.GetKeyPolicyRequest;
import com.amazonaws.services.kms.model.GetKeyPolicyResult;
import com.amazonaws.services.kms.model.GetKeyRotationStatusRequest;
import com.amazonaws.services.kms.model.GetKeyRotationStatusResult;
import com.amazonaws.services.kms.model.ListAliasesRequest;
import com.amazonaws.services.kms.model.ListAliasesResult;
import com.amazonaws.services.kms.model.ListGrantsRequest;
import com.amazonaws.services.kms.model.ListGrantsResult;
import com.amazonaws.services.kms.model.ListKeyPoliciesRequest;
import com.amazonaws.services.kms.model.ListKeyPoliciesResult;
import com.amazonaws.services.kms.model.ListKeysRequest;
import com.amazonaws.services.kms.model.ListKeysResult;
import com.amazonaws.services.kms.model.ListRetirableGrantsRequest;
import com.amazonaws.services.kms.model.ListRetirableGrantsResult;
import com.amazonaws.services.kms.model.PutKeyPolicyRequest;
import com.amazonaws.services.kms.model.PutKeyPolicyResult;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.services.kms.model.ReEncryptResult;
import com.amazonaws.services.kms.model.RetireGrantRequest;
import com.amazonaws.services.kms.model.RetireGrantResult;
import com.amazonaws.services.kms.model.RevokeGrantRequest;
import com.amazonaws.services.kms.model.RevokeGrantResult;
import com.amazonaws.services.kms.model.ScheduleKeyDeletionRequest;
import com.amazonaws.services.kms.model.ScheduleKeyDeletionResult;
import com.amazonaws.services.kms.model.UpdateAliasRequest;
import com.amazonaws.services.kms.model.UpdateAliasResult;
import com.amazonaws.services.kms.model.UpdateKeyDescriptionRequest;
import com.amazonaws.services.kms.model.UpdateKeyDescriptionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSKMSAsyncClient
extends AWSKMSClient
implements AWSKMSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSKMSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSKMSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSKMSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSKMSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSKMSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSKMSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSKMSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelKeyDeletionResult> cancelKeyDeletionAsync(CancelKeyDeletionRequest request) {
        return this.cancelKeyDeletionAsync(request, null);
    }

    @Override
    public Future<CancelKeyDeletionResult> cancelKeyDeletionAsync(final CancelKeyDeletionRequest request, final AsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelKeyDeletionResult>(){

            @Override
            public CancelKeyDeletionResult call() throws Exception {
                CancelKeyDeletionResult result;
                try {
                    result = AWSKMSAsyncClient.this.cancelKeyDeletion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request) {
        return this.createAliasAsync(request, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(final CreateAliasRequest request, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result;
                try {
                    result = AWSKMSAsyncClient.this.createAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(CreateGrantRequest request) {
        return this.createGrantAsync(request, null);
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(final CreateGrantRequest request, final AsyncHandler<CreateGrantRequest, CreateGrantResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateGrantResult>(){

            @Override
            public CreateGrantResult call() throws Exception {
                CreateGrantResult result;
                try {
                    result = AWSKMSAsyncClient.this.createGrant(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(CreateKeyRequest request) {
        return this.createKeyAsync(request, null);
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(final CreateKeyRequest request, final AsyncHandler<CreateKeyRequest, CreateKeyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateKeyResult>(){

            @Override
            public CreateKeyResult call() throws Exception {
                CreateKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.createKey(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync() {
        return this.createKeyAsync(new CreateKeyRequest());
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(AsyncHandler<CreateKeyRequest, CreateKeyResult> asyncHandler) {
        return this.createKeyAsync(new CreateKeyRequest(), asyncHandler);
    }

    @Override
    public Future<DecryptResult> decryptAsync(DecryptRequest request) {
        return this.decryptAsync(request, null);
    }

    @Override
    public Future<DecryptResult> decryptAsync(final DecryptRequest request, final AsyncHandler<DecryptRequest, DecryptResult> asyncHandler) {
        return this.executorService.submit(new Callable<DecryptResult>(){

            @Override
            public DecryptResult call() throws Exception {
                DecryptResult result;
                try {
                    result = AWSKMSAsyncClient.this.decrypt(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(DeleteAliasRequest request) {
        return this.deleteAliasAsync(request, null);
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(final DeleteAliasRequest request, final AsyncHandler<DeleteAliasRequest, DeleteAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAliasResult>(){

            @Override
            public DeleteAliasResult call() throws Exception {
                DeleteAliasResult result;
                try {
                    result = AWSKMSAsyncClient.this.deleteAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeKeyResult> describeKeyAsync(DescribeKeyRequest request) {
        return this.describeKeyAsync(request, null);
    }

    @Override
    public Future<DescribeKeyResult> describeKeyAsync(final DescribeKeyRequest request, final AsyncHandler<DescribeKeyRequest, DescribeKeyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeKeyResult>(){

            @Override
            public DescribeKeyResult call() throws Exception {
                DescribeKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.describeKey(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableKeyResult> disableKeyAsync(DisableKeyRequest request) {
        return this.disableKeyAsync(request, null);
    }

    @Override
    public Future<DisableKeyResult> disableKeyAsync(final DisableKeyRequest request, final AsyncHandler<DisableKeyRequest, DisableKeyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableKeyResult>(){

            @Override
            public DisableKeyResult call() throws Exception {
                DisableKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.disableKey(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableKeyRotationResult> disableKeyRotationAsync(DisableKeyRotationRequest request) {
        return this.disableKeyRotationAsync(request, null);
    }

    @Override
    public Future<DisableKeyRotationResult> disableKeyRotationAsync(final DisableKeyRotationRequest request, final AsyncHandler<DisableKeyRotationRequest, DisableKeyRotationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableKeyRotationResult>(){

            @Override
            public DisableKeyRotationResult call() throws Exception {
                DisableKeyRotationResult result;
                try {
                    result = AWSKMSAsyncClient.this.disableKeyRotation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableKeyResult> enableKeyAsync(EnableKeyRequest request) {
        return this.enableKeyAsync(request, null);
    }

    @Override
    public Future<EnableKeyResult> enableKeyAsync(final EnableKeyRequest request, final AsyncHandler<EnableKeyRequest, EnableKeyResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableKeyResult>(){

            @Override
            public EnableKeyResult call() throws Exception {
                EnableKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.enableKey(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableKeyRotationResult> enableKeyRotationAsync(EnableKeyRotationRequest request) {
        return this.enableKeyRotationAsync(request, null);
    }

    @Override
    public Future<EnableKeyRotationResult> enableKeyRotationAsync(final EnableKeyRotationRequest request, final AsyncHandler<EnableKeyRotationRequest, EnableKeyRotationResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableKeyRotationResult>(){

            @Override
            public EnableKeyRotationResult call() throws Exception {
                EnableKeyRotationResult result;
                try {
                    result = AWSKMSAsyncClient.this.enableKeyRotation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EncryptResult> encryptAsync(EncryptRequest request) {
        return this.encryptAsync(request, null);
    }

    @Override
    public Future<EncryptResult> encryptAsync(final EncryptRequest request, final AsyncHandler<EncryptRequest, EncryptResult> asyncHandler) {
        return this.executorService.submit(new Callable<EncryptResult>(){

            @Override
            public EncryptResult call() throws Exception {
                EncryptResult result;
                try {
                    result = AWSKMSAsyncClient.this.encrypt(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyResult> generateDataKeyAsync(GenerateDataKeyRequest request) {
        return this.generateDataKeyAsync(request, null);
    }

    @Override
    public Future<GenerateDataKeyResult> generateDataKeyAsync(final GenerateDataKeyRequest request, final AsyncHandler<GenerateDataKeyRequest, GenerateDataKeyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GenerateDataKeyResult>(){

            @Override
            public GenerateDataKeyResult call() throws Exception {
                GenerateDataKeyResult result;
                try {
                    result = AWSKMSAsyncClient.this.generateDataKey(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyWithoutPlaintextResult> generateDataKeyWithoutPlaintextAsync(GenerateDataKeyWithoutPlaintextRequest request) {
        return this.generateDataKeyWithoutPlaintextAsync(request, null);
    }

    @Override
    public Future<GenerateDataKeyWithoutPlaintextResult> generateDataKeyWithoutPlaintextAsync(final GenerateDataKeyWithoutPlaintextRequest request, final AsyncHandler<GenerateDataKeyWithoutPlaintextRequest, GenerateDataKeyWithoutPlaintextResult> asyncHandler) {
        return this.executorService.submit(new Callable<GenerateDataKeyWithoutPlaintextResult>(){

            @Override
            public GenerateDataKeyWithoutPlaintextResult call() throws Exception {
                GenerateDataKeyWithoutPlaintextResult result;
                try {
                    result = AWSKMSAsyncClient.this.generateDataKeyWithoutPlaintext(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(GenerateRandomRequest request) {
        return this.generateRandomAsync(request, null);
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(final GenerateRandomRequest request, final AsyncHandler<GenerateRandomRequest, GenerateRandomResult> asyncHandler) {
        return this.executorService.submit(new Callable<GenerateRandomResult>(){

            @Override
            public GenerateRandomResult call() throws Exception {
                GenerateRandomResult result;
                try {
                    result = AWSKMSAsyncClient.this.generateRandom(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync() {
        return this.generateRandomAsync(new GenerateRandomRequest());
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(AsyncHandler<GenerateRandomRequest, GenerateRandomResult> asyncHandler) {
        return this.generateRandomAsync(new GenerateRandomRequest(), asyncHandler);
    }

    @Override
    public Future<GetKeyPolicyResult> getKeyPolicyAsync(GetKeyPolicyRequest request) {
        return this.getKeyPolicyAsync(request, null);
    }

    @Override
    public Future<GetKeyPolicyResult> getKeyPolicyAsync(final GetKeyPolicyRequest request, final AsyncHandler<GetKeyPolicyRequest, GetKeyPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetKeyPolicyResult>(){

            @Override
            public GetKeyPolicyResult call() throws Exception {
                GetKeyPolicyResult result;
                try {
                    result = AWSKMSAsyncClient.this.getKeyPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyRotationStatusResult> getKeyRotationStatusAsync(GetKeyRotationStatusRequest request) {
        return this.getKeyRotationStatusAsync(request, null);
    }

    @Override
    public Future<GetKeyRotationStatusResult> getKeyRotationStatusAsync(final GetKeyRotationStatusRequest request, final AsyncHandler<GetKeyRotationStatusRequest, GetKeyRotationStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetKeyRotationStatusResult>(){

            @Override
            public GetKeyRotationStatusResult call() throws Exception {
                GetKeyRotationStatusResult result;
                try {
                    result = AWSKMSAsyncClient.this.getKeyRotationStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest request) {
        return this.listAliasesAsync(request, null);
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(final ListAliasesRequest request, final AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                ListAliasesResult result;
                try {
                    result = AWSKMSAsyncClient.this.listAliases(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync() {
        return this.listAliasesAsync(new ListAliasesRequest());
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        return this.listAliasesAsync(new ListAliasesRequest(), asyncHandler);
    }

    @Override
    public Future<ListGrantsResult> listGrantsAsync(ListGrantsRequest request) {
        return this.listGrantsAsync(request, null);
    }

    @Override
    public Future<ListGrantsResult> listGrantsAsync(final ListGrantsRequest request, final AsyncHandler<ListGrantsRequest, ListGrantsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListGrantsResult>(){

            @Override
            public ListGrantsResult call() throws Exception {
                ListGrantsResult result;
                try {
                    result = AWSKMSAsyncClient.this.listGrants(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeyPoliciesResult> listKeyPoliciesAsync(ListKeyPoliciesRequest request) {
        return this.listKeyPoliciesAsync(request, null);
    }

    @Override
    public Future<ListKeyPoliciesResult> listKeyPoliciesAsync(final ListKeyPoliciesRequest request, final AsyncHandler<ListKeyPoliciesRequest, ListKeyPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListKeyPoliciesResult>(){

            @Override
            public ListKeyPoliciesResult call() throws Exception {
                ListKeyPoliciesResult result;
                try {
                    result = AWSKMSAsyncClient.this.listKeyPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest request) {
        return this.listKeysAsync(request, null);
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(final ListKeysRequest request, final AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListKeysResult>(){

            @Override
            public ListKeysResult call() throws Exception {
                ListKeysResult result;
                try {
                    result = AWSKMSAsyncClient.this.listKeys(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync() {
        return this.listKeysAsync(new ListKeysRequest());
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) {
        return this.listKeysAsync(new ListKeysRequest(), asyncHandler);
    }

    @Override
    public Future<ListRetirableGrantsResult> listRetirableGrantsAsync(ListRetirableGrantsRequest request) {
        return this.listRetirableGrantsAsync(request, null);
    }

    @Override
    public Future<ListRetirableGrantsResult> listRetirableGrantsAsync(final ListRetirableGrantsRequest request, final AsyncHandler<ListRetirableGrantsRequest, ListRetirableGrantsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRetirableGrantsResult>(){

            @Override
            public ListRetirableGrantsResult call() throws Exception {
                ListRetirableGrantsResult result;
                try {
                    result = AWSKMSAsyncClient.this.listRetirableGrants(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutKeyPolicyResult> putKeyPolicyAsync(PutKeyPolicyRequest request) {
        return this.putKeyPolicyAsync(request, null);
    }

    @Override
    public Future<PutKeyPolicyResult> putKeyPolicyAsync(final PutKeyPolicyRequest request, final AsyncHandler<PutKeyPolicyRequest, PutKeyPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutKeyPolicyResult>(){

            @Override
            public PutKeyPolicyResult call() throws Exception {
                PutKeyPolicyResult result;
                try {
                    result = AWSKMSAsyncClient.this.putKeyPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReEncryptResult> reEncryptAsync(ReEncryptRequest request) {
        return this.reEncryptAsync(request, null);
    }

    @Override
    public Future<ReEncryptResult> reEncryptAsync(final ReEncryptRequest request, final AsyncHandler<ReEncryptRequest, ReEncryptResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReEncryptResult>(){

            @Override
            public ReEncryptResult call() throws Exception {
                ReEncryptResult result;
                try {
                    result = AWSKMSAsyncClient.this.reEncrypt(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync(RetireGrantRequest request) {
        return this.retireGrantAsync(request, null);
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync(final RetireGrantRequest request, final AsyncHandler<RetireGrantRequest, RetireGrantResult> asyncHandler) {
        return this.executorService.submit(new Callable<RetireGrantResult>(){

            @Override
            public RetireGrantResult call() throws Exception {
                RetireGrantResult result;
                try {
                    result = AWSKMSAsyncClient.this.retireGrant(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync() {
        return this.retireGrantAsync(new RetireGrantRequest());
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync(AsyncHandler<RetireGrantRequest, RetireGrantResult> asyncHandler) {
        return this.retireGrantAsync(new RetireGrantRequest(), asyncHandler);
    }

    @Override
    public Future<RevokeGrantResult> revokeGrantAsync(RevokeGrantRequest request) {
        return this.revokeGrantAsync(request, null);
    }

    @Override
    public Future<RevokeGrantResult> revokeGrantAsync(final RevokeGrantRequest request, final AsyncHandler<RevokeGrantRequest, RevokeGrantResult> asyncHandler) {
        return this.executorService.submit(new Callable<RevokeGrantResult>(){

            @Override
            public RevokeGrantResult call() throws Exception {
                RevokeGrantResult result;
                try {
                    result = AWSKMSAsyncClient.this.revokeGrant(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScheduleKeyDeletionResult> scheduleKeyDeletionAsync(ScheduleKeyDeletionRequest request) {
        return this.scheduleKeyDeletionAsync(request, null);
    }

    @Override
    public Future<ScheduleKeyDeletionResult> scheduleKeyDeletionAsync(final ScheduleKeyDeletionRequest request, final AsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResult> asyncHandler) {
        return this.executorService.submit(new Callable<ScheduleKeyDeletionResult>(){

            @Override
            public ScheduleKeyDeletionResult call() throws Exception {
                ScheduleKeyDeletionResult result;
                try {
                    result = AWSKMSAsyncClient.this.scheduleKeyDeletion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest request) {
        return this.updateAliasAsync(request, null);
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(final UpdateAliasRequest request, final AsyncHandler<UpdateAliasRequest, UpdateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateAliasResult>(){

            @Override
            public UpdateAliasResult call() throws Exception {
                UpdateAliasResult result;
                try {
                    result = AWSKMSAsyncClient.this.updateAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateKeyDescriptionResult> updateKeyDescriptionAsync(UpdateKeyDescriptionRequest request) {
        return this.updateKeyDescriptionAsync(request, null);
    }

    @Override
    public Future<UpdateKeyDescriptionResult> updateKeyDescriptionAsync(final UpdateKeyDescriptionRequest request, final AsyncHandler<UpdateKeyDescriptionRequest, UpdateKeyDescriptionResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateKeyDescriptionResult>(){

            @Override
            public UpdateKeyDescriptionResult call() throws Exception {
                UpdateKeyDescriptionResult result;
                try {
                    result = AWSKMSAsyncClient.this.updateKeyDescription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

