/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisvideo.model.ChannelProtocol;
import com.amazonaws.services.kinesisvideo.model.ChannelRole;
import com.amazonaws.services.kinesisvideo.model.transform.SingleMasterChannelEndpointConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SingleMasterChannelEndpointConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> protocols;
    private String role;

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<String>(protocols);
    }

    public SingleMasterChannelEndpointConfiguration withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols(new ArrayList<String>(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add(ele);
        }
        return this;
    }

    public SingleMasterChannelEndpointConfiguration withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public SingleMasterChannelEndpointConfiguration withProtocols(ChannelProtocol ... protocols) {
        ArrayList<String> protocolsCopy = new ArrayList<String>(protocols.length);
        for (ChannelProtocol value : protocols) {
            protocolsCopy.add(value.toString());
        }
        if (this.getProtocols() == null) {
            this.setProtocols(protocolsCopy);
        } else {
            this.getProtocols().addAll(protocolsCopy);
        }
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public SingleMasterChannelEndpointConfiguration withRole(String role) {
        this.setRole(role);
        return this;
    }

    public SingleMasterChannelEndpointConfiguration withRole(ChannelRole role) {
        this.role = role.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMasterChannelEndpointConfiguration)) {
            return false;
        }
        SingleMasterChannelEndpointConfiguration other = (SingleMasterChannelEndpointConfiguration)obj;
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        return other.getRole() == null || other.getRole().equals(this.getRole());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        return hashCode;
    }

    public SingleMasterChannelEndpointConfiguration clone() {
        try {
            return (SingleMasterChannelEndpointConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SingleMasterChannelEndpointConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

