/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.transform.GoogleDriveConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GoogleDriveConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String secretArn;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private List<DataSourceToIndexFieldMapping> fieldMappings;
    private List<String> excludeMimeTypes;
    private List<String> excludeUserAccounts;
    private List<String> excludeSharedDrives;

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public GoogleDriveConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public GoogleDriveConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public GoogleDriveConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public GoogleDriveConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public GoogleDriveConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public GoogleDriveConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public GoogleDriveConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public List<String> getExcludeMimeTypes() {
        return this.excludeMimeTypes;
    }

    public void setExcludeMimeTypes(Collection<String> excludeMimeTypes) {
        if (excludeMimeTypes == null) {
            this.excludeMimeTypes = null;
            return;
        }
        this.excludeMimeTypes = new ArrayList<String>(excludeMimeTypes);
    }

    public GoogleDriveConfiguration withExcludeMimeTypes(String ... excludeMimeTypes) {
        if (this.excludeMimeTypes == null) {
            this.setExcludeMimeTypes(new ArrayList<String>(excludeMimeTypes.length));
        }
        for (String ele : excludeMimeTypes) {
            this.excludeMimeTypes.add(ele);
        }
        return this;
    }

    public GoogleDriveConfiguration withExcludeMimeTypes(Collection<String> excludeMimeTypes) {
        this.setExcludeMimeTypes(excludeMimeTypes);
        return this;
    }

    public List<String> getExcludeUserAccounts() {
        return this.excludeUserAccounts;
    }

    public void setExcludeUserAccounts(Collection<String> excludeUserAccounts) {
        if (excludeUserAccounts == null) {
            this.excludeUserAccounts = null;
            return;
        }
        this.excludeUserAccounts = new ArrayList<String>(excludeUserAccounts);
    }

    public GoogleDriveConfiguration withExcludeUserAccounts(String ... excludeUserAccounts) {
        if (this.excludeUserAccounts == null) {
            this.setExcludeUserAccounts(new ArrayList<String>(excludeUserAccounts.length));
        }
        for (String ele : excludeUserAccounts) {
            this.excludeUserAccounts.add(ele);
        }
        return this;
    }

    public GoogleDriveConfiguration withExcludeUserAccounts(Collection<String> excludeUserAccounts) {
        this.setExcludeUserAccounts(excludeUserAccounts);
        return this;
    }

    public List<String> getExcludeSharedDrives() {
        return this.excludeSharedDrives;
    }

    public void setExcludeSharedDrives(Collection<String> excludeSharedDrives) {
        if (excludeSharedDrives == null) {
            this.excludeSharedDrives = null;
            return;
        }
        this.excludeSharedDrives = new ArrayList<String>(excludeSharedDrives);
    }

    public GoogleDriveConfiguration withExcludeSharedDrives(String ... excludeSharedDrives) {
        if (this.excludeSharedDrives == null) {
            this.setExcludeSharedDrives(new ArrayList<String>(excludeSharedDrives.length));
        }
        for (String ele : excludeSharedDrives) {
            this.excludeSharedDrives.add(ele);
        }
        return this;
    }

    public GoogleDriveConfiguration withExcludeSharedDrives(Collection<String> excludeSharedDrives) {
        this.setExcludeSharedDrives(excludeSharedDrives);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings()).append(",");
        }
        if (this.getExcludeMimeTypes() != null) {
            sb.append("ExcludeMimeTypes: ").append(this.getExcludeMimeTypes()).append(",");
        }
        if (this.getExcludeUserAccounts() != null) {
            sb.append("ExcludeUserAccounts: ").append(this.getExcludeUserAccounts()).append(",");
        }
        if (this.getExcludeSharedDrives() != null) {
            sb.append("ExcludeSharedDrives: ").append(this.getExcludeSharedDrives());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GoogleDriveConfiguration)) {
            return false;
        }
        GoogleDriveConfiguration other = (GoogleDriveConfiguration)obj;
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        if (other.getFieldMappings() != null && !other.getFieldMappings().equals(this.getFieldMappings())) {
            return false;
        }
        if (other.getExcludeMimeTypes() == null ^ this.getExcludeMimeTypes() == null) {
            return false;
        }
        if (other.getExcludeMimeTypes() != null && !other.getExcludeMimeTypes().equals(this.getExcludeMimeTypes())) {
            return false;
        }
        if (other.getExcludeUserAccounts() == null ^ this.getExcludeUserAccounts() == null) {
            return false;
        }
        if (other.getExcludeUserAccounts() != null && !other.getExcludeUserAccounts().equals(this.getExcludeUserAccounts())) {
            return false;
        }
        if (other.getExcludeSharedDrives() == null ^ this.getExcludeSharedDrives() == null) {
            return false;
        }
        return other.getExcludeSharedDrives() == null || other.getExcludeSharedDrives().equals(this.getExcludeSharedDrives());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeMimeTypes() == null ? 0 : this.getExcludeMimeTypes().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeUserAccounts() == null ? 0 : this.getExcludeUserAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeSharedDrives() == null ? 0 : this.getExcludeSharedDrives().hashCode());
        return hashCode;
    }

    public GoogleDriveConfiguration clone() {
        try {
            return (GoogleDriveConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GoogleDriveConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

