/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.Configuration;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ConfigurationMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> KAFKAVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kafkaVersions").build();
    private static final MarshallingInfo<StructuredPojo> LATESTREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestRevision").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final ConfigurationMarshaller instance = new ConfigurationMarshaller();

    public static ConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Configuration configuration, ProtocolMarshaller protocolMarshaller) {
        if (configuration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configuration.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)configuration.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)configuration.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(configuration.getKafkaVersions(), KAFKAVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)configuration.getLatestRevision(), LATESTREVISION_BINDING);
            protocolMarshaller.marshall((Object)configuration.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)configuration.getState(), STATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

