/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.ClusterOperationInfo;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ClusterOperationInfoMarshaller {
    private static final MarshallingInfo<String> CLIENTREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientRequestId").build();
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterArn").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> ERRORINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorInfo").build();
    private static final MarshallingInfo<String> OPERATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationArn").build();
    private static final MarshallingInfo<String> OPERATIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationState").build();
    private static final MarshallingInfo<List> OPERATIONSTEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationSteps").build();
    private static final MarshallingInfo<String> OPERATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationType").build();
    private static final MarshallingInfo<StructuredPojo> SOURCECLUSTERINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceClusterInfo").build();
    private static final MarshallingInfo<StructuredPojo> TARGETCLUSTERINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetClusterInfo").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONNECTIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcConnectionInfo").build();
    private static final ClusterOperationInfoMarshaller instance = new ClusterOperationInfoMarshaller();

    public static ClusterOperationInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterOperationInfo clusterOperationInfo, ProtocolMarshaller protocolMarshaller) {
        if (clusterOperationInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clusterOperationInfo.getClientRequestId(), CLIENTREQUESTID_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getClusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getErrorInfo(), ERRORINFO_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getOperationArn(), OPERATIONARN_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getOperationState(), OPERATIONSTATE_BINDING);
            protocolMarshaller.marshall(clusterOperationInfo.getOperationSteps(), OPERATIONSTEPS_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getOperationType(), OPERATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getSourceClusterInfo(), SOURCECLUSTERINFO_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getTargetClusterInfo(), TARGETCLUSTERINFO_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationInfo.getVpcConnectionInfo(), VPCCONNECTIONINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

