/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsecuretunneling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotsecuretunneling.model.DestinationConfig;
import com.amazonaws.services.iotsecuretunneling.model.Tag;
import com.amazonaws.services.iotsecuretunneling.model.TimeoutConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenTunnelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<Tag> tags;
    private DestinationConfig destinationConfig;
    private TimeoutConfig timeoutConfig;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public OpenTunnelRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public OpenTunnelRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public OpenTunnelRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setDestinationConfig(DestinationConfig destinationConfig) {
        this.destinationConfig = destinationConfig;
    }

    public DestinationConfig getDestinationConfig() {
        return this.destinationConfig;
    }

    public OpenTunnelRequest withDestinationConfig(DestinationConfig destinationConfig) {
        this.setDestinationConfig(destinationConfig);
        return this;
    }

    public void setTimeoutConfig(TimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    public TimeoutConfig getTimeoutConfig() {
        return this.timeoutConfig;
    }

    public OpenTunnelRequest withTimeoutConfig(TimeoutConfig timeoutConfig) {
        this.setTimeoutConfig(timeoutConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDestinationConfig() != null) {
            sb.append("DestinationConfig: ").append(this.getDestinationConfig()).append(",");
        }
        if (this.getTimeoutConfig() != null) {
            sb.append("TimeoutConfig: ").append(this.getTimeoutConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenTunnelRequest)) {
            return false;
        }
        OpenTunnelRequest other = (OpenTunnelRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDestinationConfig() == null ^ this.getDestinationConfig() == null) {
            return false;
        }
        if (other.getDestinationConfig() != null && !other.getDestinationConfig().equals(this.getDestinationConfig())) {
            return false;
        }
        if (other.getTimeoutConfig() == null ^ this.getTimeoutConfig() == null) {
            return false;
        }
        return other.getTimeoutConfig() == null || other.getTimeoutConfig().equals(this.getTimeoutConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationConfig() == null ? 0 : this.getDestinationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutConfig() == null ? 0 : this.getTimeoutConfig().hashCode());
        return hashCode;
    }

    public OpenTunnelRequest clone() {
        return (OpenTunnelRequest)super.clone();
    }
}

